/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.config.snmp;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.config.api.collection.IDataCollectionConfig;
import org.opennms.netmgt.config.api.collection.IDataCollectionGroup;
import org.opennms.netmgt.config.api.collection.ISnmpCollection;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionGroup;
import org.opennms.netmgt.sampler.config.snmp.DataCollectionInitializationCache;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollection;
import org.opennms.netmgt.sampler.config.snmp.SnmpCollectionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="datacollection-config")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DataCollectionConfig
implements IDataCollectionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionConfig.class);
    private static final ISnmpCollection[] EMPTY_SNMP_COLLECTION_ARRAY = new ISnmpCollection[0];
    @XmlElement(name="snmp-collection")
    List<SnmpCollection> m_snmpCollections = new ArrayList<SnmpCollection>();

    public ISnmpCollection[] getSnmpCollections() {
        return this.m_snmpCollections.toArray(EMPTY_SNMP_COLLECTION_ARRAY);
    }

    public void initialize() {
        this.initialize(new DataCollectionInitializationCache());
    }

    public void initialize(DataCollectionInitializationCache cache) {
        LOG.debug("datacollection config initializing with cache: {}", (Object)cache);
        if (this.m_snmpCollections != null) {
            for (SnmpCollection snmpCollection : this.m_snmpCollections) {
                IDataCollectionGroup[] dataCollectionGroups = snmpCollection.getDataCollectionGroups();
                if (dataCollectionGroups == null) continue;
                for (IDataCollectionGroup group : dataCollectionGroups) {
                    DataCollectionGroup collectionGroup = DataCollectionGroup.asCollectionGroup(group);
                    cache.addDataCollectionGroup(collectionGroup);
                }
            }
        }
        LOG.debug("preparing datacollection cache");
        cache.prepare();
        LOG.debug("initializing {} collections", (Object)(this.m_snmpCollections == null ? 0 : this.m_snmpCollections.size()));
        for (SnmpCollection snmpCollection : this.m_snmpCollections) {
            snmpCollection.initialize(cache);
        }
        LOG.debug("datacollection config finished initializing");
    }

    public void fillRequest(SnmpCollectionRequest request) {
        for (SnmpCollection snmpCollection : this.m_snmpCollections) {
            snmpCollection.fillRequest(request);
        }
    }

    public Set<Metric> getMetricsForGroup(String groupName) {
        for (SnmpCollection snmpCollection : this.m_snmpCollections) {
            Set<Metric> metrics = snmpCollection.getMetricsForGroup(groupName);
            if (metrics == null) continue;
            return metrics;
        }
        return null;
    }

    public Metric getMetric(String metricName) {
        for (SnmpCollection snmpCollection : this.m_snmpCollections) {
            Metric metric = snmpCollection.getMetric(metricName);
            if (metric == null) continue;
            return metric;
        }
        return null;
    }

    public String toString() {
        return "DataCollectionConfig [snmpCollections=" + this.m_snmpCollections + "]";
    }
}

