/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.SampleSerializer;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

@JsonSerialize(using=SampleSerializer.class)
public class Sample
implements Element<ValueType<?>> {
    private final Timestamp m_timestamp;
    private final String m_resource;
    private final String m_name;
    private final MetricType m_type;
    private final ValueType<?> m_value;
    private final Map<String, String> m_attributes;

    public Sample(Timestamp timestamp, String resource, String name, MetricType type, ValueType<?> value) {
        this(timestamp, resource, name, type, value, null);
    }

    public Sample(Timestamp timestamp, String resource, String name, MetricType type, ValueType<?> value, Map<String, String> attributes) {
        this.m_timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.m_resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.m_name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.m_type = (MetricType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.m_value = value;
        this.m_attributes = attributes;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public String getResource() {
        return this.m_resource;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public MetricType getType() {
        return this.m_type;
    }

    @Override
    public ValueType<?> getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[timestamp=%s, resource=%s, name=%s, type=%s, value=%s]", new Object[]{this.getClass().getSimpleName(), this.getTimestamp(), this.getResource(), this.getName(), this.getType(), this.getValue()});
    }
}

