/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.ResultsSerializer;
import org.opennms.newts.api.Timestamp;

@JsonSerialize(using=ResultsSerializer.class)
public class Results<T extends Element<?>>
implements Iterable<Row<T>> {
    Map<Timestamp, Row<T>> m_rows = Maps.newTreeMap();

    public void addElement(T sample) {
        Row<T> row = this.m_rows.get(sample.getTimestamp());
        if (row == null) {
            row = new Row(sample.getTimestamp(), sample.getResource());
            this.addRow(row);
        }
        row.addElement(sample);
    }

    public void addRow(Row<T> row) {
        this.m_rows.put(row.getTimestamp(), row);
    }

    public Collection<Row<T>> getRows() {
        return this.m_rows.values();
    }

    @Override
    public Iterator<Row<T>> iterator() {
        return this.getRows().iterator();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getRows());
    }

    public static class Row<T extends Element<?>>
    implements Iterable<T> {
        private Timestamp m_timestamp;
        private String m_resource;
        private Map<String, T> m_cells = Maps.newHashMap();

        public Row(Timestamp timestamp, String resource) {
            this.m_timestamp = timestamp;
            this.m_resource = resource;
        }

        public void addElement(T sample) {
            this.m_cells.put(sample.getName(), sample);
        }

        public T getElement(String name) {
            return (T)((Element)this.m_cells.get(name));
        }

        public Timestamp getTimestamp() {
            return this.m_timestamp;
        }

        public String getResource() {
            return this.m_resource;
        }

        public Collection<T> getElements() {
            return this.m_cells.values();
        }

        @Override
        public Iterator<T> iterator() {
            return this.getElements().iterator();
        }

        public String toString() {
            return String.format("%s[timestamp=%s, resource=%s, elements=%s", this.getClass().getSimpleName(), this.getTimestamp(), this.getResource(), this.getElements());
        }
    }
}

