/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.MeasurementSerializer;
import org.opennms.newts.api.Timestamp;

@JsonSerialize(using=MeasurementSerializer.class)
public class Measurement
implements Element<Double> {
    private final Timestamp m_timestamp;
    private final String m_resource;
    private final String m_name;
    private final double m_value;
    private final Map<String, String> m_attributes;

    public Measurement(Timestamp timestamp, String resource, String name, double value) {
        this(timestamp, resource, name, value, null);
    }

    public Measurement(Timestamp timestamp, String resource, String name, double value, Map<String, String> attributes) {
        this.m_timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.m_resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.m_name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.m_value = (Double)Preconditions.checkNotNull((Object)value, (Object)"value");
        this.m_attributes = attributes;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public String getResource() {
        return this.m_resource;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Double getValue() {
        return this.m_value;
    }

    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return String.format("%s[timestamp=%s, resource=%s, name=%s, value=%s]", this.getClass().getSimpleName(), this.getTimestamp(), this.getResource(), this.getName(), this.getValue());
    }
}

