/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.newts.api.Timestamp;

public class Duration
implements Comparable<Duration> {
    private final long m_duration;
    private final TimeUnit m_unit;

    public Duration(long duration, TimeUnit unit) {
        this.m_duration = duration;
        this.m_unit = unit;
    }

    public long convert(TimeUnit unit) {
        return unit.convert(this.getDuration(), this.getUnit());
    }

    public long asMillis() {
        return this.convert(TimeUnit.MILLISECONDS);
    }

    public long asSeconds() {
        return this.convert(TimeUnit.SECONDS);
    }

    public static Duration seconds(long seconds) {
        return new Duration(seconds, TimeUnit.SECONDS);
    }

    public static Duration millis(long millis) {
        return new Duration(millis, TimeUnit.MILLISECONDS);
    }

    public static Duration minutes(long minutes) {
        return new Duration(minutes, TimeUnit.MINUTES);
    }

    public long getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnit() {
        return this.m_unit;
    }

    public Duration plus(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return new Duration(this.convert(u) + o.convert(u), u);
    }

    public Duration times(long value) {
        return new Duration(this.getDuration() * value, this.getUnit());
    }

    public long divideBy(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.convert(u) / o.convert(u);
    }

    public boolean isMultiple(Duration o) {
        TimeUnit u = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.gt(o) && this.convert(u) % o.convert(u) == 0L;
    }

    public String toString() {
        return String.format("%s[%d, %s]", new Object[]{this.getClass().getSimpleName(), this.m_duration, this.getUnit()});
    }

    @Override
    public int compareTo(Duration o) {
        TimeUnit unit = Timestamp.finest(this.getUnit(), o.getUnit());
        return this.convert(unit) < o.convert(unit) ? -1 : (this.convert(unit) > o.convert(unit) ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Duration)) {
            return false;
        }
        return this.compareTo((Duration)o) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.convert(TimeUnit.NANOSECONDS));
    }

    public boolean lt(Duration o) {
        return this.compareTo(o) == -1;
    }

    public boolean gt(Duration o) {
        return this.compareTo(o) == 1;
    }

    public boolean lte(Duration o) {
        return this.compareTo(o) <= 0;
    }

    public boolean gte(Duration o) {
        return this.compareTo(o) >= 0;
    }
}

