/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.Util;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private static RrdDbPool instance;
    private int capacity = 200;
    private HashMap<String, RrdEntry> rrdMap = new HashMap(200);

    public static synchronized RrdDbPool getInstance() throws RrdException {
        if (instance == null) {
            instance = new RrdDbPool();
        }
        return instance;
    }

    private RrdDbPool() throws RrdException {
        RrdBackendFactory factory = RrdBackendFactory.getDefaultFactory();
        if (!(factory instanceof RrdFileBackendFactory)) {
            throw new RrdException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
    }

    public synchronized RrdDb requestRrdDb(String path) throws IOException, RrdException {
        String canonicalPath = Util.getCanonicalPath(path);
        while (!this.rrdMap.containsKey(canonicalPath) && this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RrdException(e);
            }
        }
        if (this.rrdMap.containsKey(canonicalPath)) {
            RrdEntry entry = this.rrdMap.get(canonicalPath);
            ++entry.count;
            return entry.rrdDb;
        }
        RrdDb rrdDb = new RrdDb(canonicalPath);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(RrdDef rrdDef) throws IOException, RrdException {
        String canonicalPath = Util.getCanonicalPath(rrdDef.getPath());
        while (this.rrdMap.containsKey(canonicalPath) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RrdException(e);
            }
        }
        RrdDb rrdDb = new RrdDb(rrdDef);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(String path, String sourcePath) throws IOException, RrdException, RrdException {
        String canonicalPath = Util.getCanonicalPath(path);
        while (this.rrdMap.containsKey(canonicalPath) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RrdException(e);
            }
        }
        RrdDb rrdDb = new RrdDb(canonicalPath, sourcePath);
        this.rrdMap.put(canonicalPath, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized void release(RrdDb rrdDb) throws IOException, RrdException {
        if (rrdDb == null) {
            return;
        }
        String canonicalPath = Util.getCanonicalPath(rrdDb.getPath());
        if (!this.rrdMap.containsKey(canonicalPath)) {
            throw new RrdException("Could not release [" + canonicalPath + "], the file was never requested");
        }
        RrdEntry entry = this.rrdMap.get(canonicalPath);
        if (--entry.count <= 0) {
            this.rrdMap.remove(canonicalPath);
            this.notifyAll();
            entry.rrdDb.close();
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized String[] getOpenFiles() {
        return this.rrdMap.keySet().toArray(new String[0]);
    }

    public synchronized int getOpenFileCount() {
        return this.rrdMap.size();
    }

    private static final class RrdEntry {
        RrdDb rrdDb;
        int count;

        RrdEntry(RrdDb rrdDb) {
            this.rrdDb = rrdDb;
            this.count = 1;
        }
    }
}

