/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.opennms.newts.aggregate.Aggregation;
import org.opennms.newts.aggregate.Compute;
import org.opennms.newts.aggregate.Export;
import org.opennms.newts.aggregate.PrimaryData;
import org.opennms.newts.aggregate.Rate;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.query.ResultDescriptor;

public class ResultProcessor {
    private final String m_resource;
    private final Timestamp m_start;
    private final Timestamp m_end;
    private final ResultDescriptor m_resultDescriptor;
    private final Duration m_resolution;

    public ResultProcessor(String resource, Timestamp start, Timestamp end, ResultDescriptor descriptor, Duration resolution) {
        this.m_resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
        this.m_start = (Timestamp)Preconditions.checkNotNull((Object)start, (Object)"start argument");
        this.m_end = (Timestamp)Preconditions.checkNotNull((Object)end, (Object)"end argument");
        this.m_resultDescriptor = (ResultDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"result descriptor argument");
        this.m_resolution = (Duration)Preconditions.checkNotNull((Object)resolution, (Object)"resolution argument");
    }

    public Results<Measurement> process(Iterator<Results.Row<Sample>> samples) {
        Preconditions.checkNotNull(samples, (Object)"samples argument");
        Rate rate = new Rate(samples, this.m_resultDescriptor.getSourceNames());
        PrimaryData primaryData = new PrimaryData(this.m_resource, this.m_start.minus(this.m_resolution), this.m_end, this.m_resultDescriptor, rate);
        Aggregation aggregation = new Aggregation(this.m_resource, this.m_start, this.m_end, this.m_resultDescriptor, this.m_resolution, primaryData);
        Compute compute = new Compute(this.m_resultDescriptor, aggregation);
        Export exports = new Export(this.m_resultDescriptor.getExports(), compute);
        Results measurements = new Results();
        for (Results.Row<Measurement> row : exports) {
            measurements.addRow(row);
        }
        return measurements;
    }
}

