/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.inject.Inject;
import javax.inject.Named;

public class SchemaManager
implements AutoCloseable {
    private static final String KEYSPACE = "$KEYSPACE$";
    private static final String SCHEMA_FILE = "schema.cql";
    private String m_keyspace;
    private Cluster m_cluster;
    private Session m_session;

    @Inject
    public SchemaManager(@Named(value="cassandraKeyspace") String keyspace, @Named(value="cassandraHost") String host, @Named(value="cassandraPort") int port) {
        this.m_keyspace = keyspace;
        this.m_cluster = Cluster.builder().withPort(port).addContactPoint(host).build();
        this.m_session = this.m_cluster.connect();
    }

    public void create() throws IOException {
        this.create(true);
    }

    public void create(boolean ifNotExists) throws IOException {
        String line;
        InputStream stream = this.getClass().getResourceAsStream("/schema.cql");
        if (stream == null) {
            throw new RuntimeException(String.format("%s missing from classpath!", SCHEMA_FILE));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder statement = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            String scrubbed = this.scrub(line);
            statement.append(scrubbed);
            if (!scrubbed.endsWith(";")) continue;
            try {
                this.m_session.execute(statement.toString().replace(KEYSPACE, this.m_keyspace));
            }
            catch (AlreadyExistsException e) {
                if (ifNotExists) {
                    System.err.printf("%s (skipping)%n", e.getLocalizedMessage());
                }
                throw e;
            }
            statement = new StringBuilder();
        }
    }

    private String scrub(String line) {
        return line.replace("\\s+", "").replace("//.*$", "").replace(";.*$", ";");
    }

    @Override
    public void close() throws Exception {
        this.m_cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws IOException {
        String keyspace = System.getProperty("cassandraKeyspace", "newts");
        String hostname = System.getProperty("cassandraHost", "localhost");
        String port = System.getProperty("cassandraPort", "9042");
        boolean ifSchemaNotExists = Boolean.valueOf(System.getProperty("ifSchemaNotExists", "true"));
        int portNumber = -1;
        try {
            portNumber = Integer.valueOf(port);
        }
        catch (NumberFormatException e) {
            System.err.printf("%s is an invalid port number", port);
            System.exit(1);
        }
        try {
            new SchemaManager(keyspace, hostname, portNumber).create(ifSchemaNotExists);
        }
        finally {
            System.exit(0);
        }
    }
}

