/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.datastax.driver.core.Row;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

class DriverAdapter
implements Iterable<Results.Row<Sample>>,
Iterator<Results.Row<Sample>> {
    private final Iterator<Row> m_results;
    private final Set<String> m_metrics;
    private Results.Row<Sample> m_next = null;
    private int m_count = 0;

    DriverAdapter(Iterator<Row> input) {
        this(input, Collections.emptySet());
    }

    DriverAdapter(Iterator<Row> input, Set<String> metrics) {
        this.m_results = (Iterator)Preconditions.checkNotNull(input, (Object)"input argument");
        this.m_metrics = (Set)Preconditions.checkNotNull(metrics, (Object)"metrics argument");
        if (this.m_results.hasNext()) {
            Sample m = this.getNextSample();
            this.m_next = new Results.Row(m.getTimestamp(), m.getResource());
            this.addSample(this.m_next, m);
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Results.Row<Sample> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Results.Row nextNext = null;
        while (this.m_results.hasNext()) {
            Sample m = this.getNextSample();
            if (m.getTimestamp().gt(this.m_next.getTimestamp())) {
                nextNext = new Results.Row(m.getTimestamp(), m.getResource());
                this.addSample((Results.Row<Sample>)nextNext, m);
                break;
            }
            this.addSample(this.m_next, m);
        }
        try {
            Results.Row<Sample> row = this.m_next;
            return row;
        }
        finally {
            this.m_next = nextNext;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Sample>> iterator() {
        return this;
    }

    public int getResultCount() {
        return this.m_count;
    }

    private void addSample(Results.Row<Sample> row, Sample sample) {
        if (this.m_metrics.size() == 0 || this.m_metrics.contains(sample.getName())) {
            row.addElement((Element)sample);
        }
    }

    private Sample getNextSample() {
        ++this.m_count;
        return DriverAdapter.getSample(this.m_results.next());
    }

    private static Sample getSample(Row row) {
        ValueType<?> value = DriverAdapter.getValue(row);
        return new Sample(DriverAdapter.getTimestamp(row), DriverAdapter.getResource(row), DriverAdapter.getMetricName(row), value.getType(), value, DriverAdapter.getAttributes(row));
    }

    private static ValueType<?> getValue(Row row) {
        return ValueType.compose((ByteBuffer)row.getBytes("value"));
    }

    private static String getMetricName(Row row) {
        return row.getString("metric_name");
    }

    private static Timestamp getTimestamp(Row row) {
        return Timestamp.fromEpochMillis((long)row.getDate("collected_at").getTime());
    }

    private static String getResource(Row row) {
        return row.getString("resource");
    }

    private static Map<String, String> getAttributes(Row row) {
        return row.getMap("attributes", String.class, String.class);
    }
}

