/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.aggregate.IntervalGenerator;
import org.opennms.newts.aggregate.ResultProcessor;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.SampleProcessorService;
import org.opennms.newts.api.SampleRepository;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.query.ResultDescriptor;
import org.opennms.newts.persistence.cassandra.ConcurrentResultWrapper;
import org.opennms.newts.persistence.cassandra.DriverAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSampleRepository
implements SampleRepository {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSampleRepository.class);
    private Session m_session;
    private final MetricRegistry m_registry;
    private SampleProcessorService m_processorService;
    private Duration m_resourceShard = Duration.seconds((long)600000L);
    private PreparedStatement m_selectStatement;
    private int m_ttl;

    @Inject
    public CassandraSampleRepository(@Named(value="samples.cassandra.keyspace") String keyspace, @Named(value="samples.cassandra.host") String host, @Named(value="samples.cassandra.port") int port, @Named(value="samples.cassandra.time-to-live") int ttl, MetricRegistry registry, SampleProcessorService processorService) {
        Preconditions.checkNotNull((Object)keyspace, (Object)"Cassandra keyspace argument");
        Preconditions.checkNotNull((Object)host, (Object)"Cassandra host argument");
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (Object)"Negative Cassandra column TTL");
        this.m_ttl = ttl;
        Cluster cluster = Cluster.builder().withPort(port).addContactPoint(host).build();
        this.m_session = cluster.connect(keyspace);
        this.m_registry = (MetricRegistry)Preconditions.checkNotNull((Object)registry, (Object)"metric registry argument");
        this.m_processorService = processorService;
        Select select = QueryBuilder.select().from("samples");
        select.where(QueryBuilder.eq((String)"partition", (Object)QueryBuilder.bindMarker((String)"partition")));
        select.where(QueryBuilder.eq((String)"resource", (Object)QueryBuilder.bindMarker((String)"resource")));
        select.where(QueryBuilder.gte((String)"collected_at", (Object)QueryBuilder.bindMarker((String)"start")));
        select.where(QueryBuilder.lte((String)"collected_at", (Object)QueryBuilder.bindMarker((String)"end")));
        this.m_selectStatement = this.m_session.prepare((RegularStatement)select);
    }

    public Results<Measurement> select(String resource, Optional<Timestamp> start, Optional<Timestamp> end, ResultDescriptor descriptor, Duration resolution) {
        this.validateSelect(start, end);
        Timestamp upper = end.isPresent() ? (Timestamp)end.get() : Timestamp.now();
        Timestamp lower = start.isPresent() ? (Timestamp)start.get() : upper.minus(Duration.seconds((long)86400L));
        LOG.debug("Querying database for resource {}, from {} to {}", new Object[]{resource, lower.minus(resolution), upper});
        DriverAdapter driverAdapter = new DriverAdapter(this.cassandraSelect(resource, lower.minus(resolution), upper), descriptor.getSourceNames());
        Results results = new ResultProcessor(resource, lower, upper, descriptor, resolution).process((Iterator)driverAdapter);
        LOG.debug("{} results returned from database", (Object)driverAdapter.getResultCount());
        return results;
    }

    public Results<Sample> select(String resource, Optional<Timestamp> start, Optional<Timestamp> end) {
        this.validateSelect(start, end);
        Timestamp upper = end.isPresent() ? (Timestamp)end.get() : Timestamp.now();
        Timestamp lower = start.isPresent() ? (Timestamp)start.get() : upper.minus(Duration.seconds((long)86400L));
        LOG.debug("Querying database for resource {}, from {} to {}", new Object[]{resource, lower, upper});
        Results samples = new Results();
        DriverAdapter driverAdapter = new DriverAdapter(this.cassandraSelect(resource, lower, upper));
        for (Results.Row<Sample> row : driverAdapter) {
            samples.addRow(row);
        }
        LOG.debug("{} results returned from database", (Object)driverAdapter.getResultCount());
        return samples;
    }

    public void insert(Collection<Sample> samples) {
        Batch batch = QueryBuilder.unloggedBatch((RegularStatement[])new RegularStatement[0]);
        for (Sample m : samples) {
            batch.add((RegularStatement)QueryBuilder.insertInto((String)"samples").value("partition", (Object)m.getTimestamp().stepFloor(this.m_resourceShard).asSeconds()).value("resource", (Object)m.getResource()).value("collected_at", (Object)m.getTimestamp().asMillis()).value("metric_name", (Object)m.getName()).value("value", (Object)ValueType.decompose((ValueType)m.getValue())).value("attributes", (Object)m.getAttributes()).using(QueryBuilder.ttl((int)this.m_ttl)));
        }
        this.m_session.execute((Statement)batch);
        if (this.m_processorService != null) {
            this.m_processorService.submit(samples);
        }
    }

    private Iterator<Row> cassandraSelect(String resource, Timestamp start, Timestamp end) {
        ArrayList futures = Lists.newArrayList();
        Timestamp lower = start.stepFloor(this.m_resourceShard);
        Timestamp upper = end.stepFloor(this.m_resourceShard);
        for (Timestamp partition : new IntervalGenerator(lower, upper, this.m_resourceShard)) {
            BoundStatement bindStatement = this.m_selectStatement.bind(new Object[0]);
            bindStatement.setInt("partition", (int)partition.asSeconds());
            bindStatement.setString("resource", resource);
            bindStatement.setDate("start", start.asDate());
            bindStatement.setDate("end", end.asDate());
            futures.add(this.m_session.executeAsync((Statement)bindStatement));
        }
        return new ConcurrentResultWrapper(futures);
    }

    private void validateSelect(Optional<Timestamp> start, Optional<Timestamp> end) {
        if (start.isPresent() && end.isPresent() && ((Timestamp)start.get()).gt((Timestamp)end.get())) {
            throw new IllegalArgumentException("start time must be less than end time");
        }
    }

    void setResourceShard(Duration resourceShard) {
        this.m_resourceShard = resourceShard;
    }
}

