/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.Serializable;
import java.net.InetAddress;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.snmp.InetAddrXmlAdapter;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="snmpAgentConfig")
public class SnmpAgentConfig
extends SnmpConfiguration
implements Serializable {
    private static final long serialVersionUID = 1456963719970029200L;
    private static final transient Logger LOG = LoggerFactory.getLogger(SnmpAgentConfig.class);
    private InetAddress m_address;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this((InetAddress)null);
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this(agentAddress, SnmpConfiguration.DEFAULTS);
    }

    public SnmpAgentConfig(InetAddress agentAddress, SnmpConfiguration defaults) {
        super(defaults);
        this.m_address = agentAddress;
    }

    public static SnmpAgentConfig parseProtocolConfigurationString(String protocolConfigString) {
        String[] attributes;
        if (protocolConfigString == null) {
            throw new IllegalArgumentException("Protocol configuration string for SnmpAgentConfig must not be null.");
        }
        if (!protocolConfigString.startsWith("snmp:")) {
            throw new IllegalArgumentException("Invalid protocol configuration string for SnmpAgentConfig: Expected it to start with snmp:" + protocolConfigString);
        }
        SnmpAgentConfig agentConfig = new SnmpAgentConfig();
        for (String attribute : attributes = protocolConfigString.substring("snmp:".length()).split(",")) {
            String[] pair = attribute.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("unexpected format for key value pair in SnmpAgentConfig configuration string" + attribute);
            }
            String key = pair[0];
            String value = pair[1];
            if ("address".equalsIgnoreCase(key) && !"null".equals(value)) {
                agentConfig.setAddress(InetAddrUtils.addr(value));
                continue;
            }
            if ("port".equalsIgnoreCase(key)) {
                agentConfig.setPort(Integer.parseInt(value));
                continue;
            }
            if ("timeout".equalsIgnoreCase(key)) {
                agentConfig.setTimeout(Integer.parseInt(value));
                continue;
            }
            if ("retries".equalsIgnoreCase(key)) {
                agentConfig.setRetries(Integer.parseInt(value));
                continue;
            }
            if ("max-vars-per-pdu".equalsIgnoreCase(key)) {
                agentConfig.setMaxVarsPerPdu(Integer.parseInt(value));
                continue;
            }
            if ("max-repetitions".equalsIgnoreCase(key)) {
                agentConfig.setMaxRepetitions(Integer.parseInt(value));
                continue;
            }
            if ("max-request-size".equalsIgnoreCase(key)) {
                agentConfig.setMaxRequestSize(Integer.parseInt(value));
                continue;
            }
            if ("version".equalsIgnoreCase(key)) {
                agentConfig.setVersionAsString(value);
                continue;
            }
            if ("security-level".equalsIgnoreCase(key)) {
                agentConfig.setSecurityLevel(Integer.parseInt(value));
                continue;
            }
            if ("security-name".equalsIgnoreCase(key)) {
                agentConfig.setSecurityName(value);
                continue;
            }
            if ("auth-passphrase".equalsIgnoreCase(key)) {
                agentConfig.setAuthPassPhrase(value);
                continue;
            }
            if ("auth-protocol".equalsIgnoreCase(key)) {
                agentConfig.setAuthProtocol(value);
                continue;
            }
            if ("priv-passphrase".equalsIgnoreCase(key)) {
                agentConfig.setPrivPassPhrase(value);
                continue;
            }
            if ("priv-protocol".equalsIgnoreCase(key)) {
                agentConfig.setPrivProtocol(value);
                continue;
            }
            if ("read-community".equalsIgnoreCase(key)) {
                agentConfig.setReadCommunity(value);
                continue;
            }
            if ("context-name".equalsIgnoreCase(key)) {
                agentConfig.setContextName(value);
                continue;
            }
            if ("engine-id".equalsIgnoreCase(key)) {
                agentConfig.setEngineId(value);
                continue;
            }
            if ("context-engine-id".equalsIgnoreCase(key)) {
                agentConfig.setContextEngineId(value);
                continue;
            }
            if ("enterprise-id".equalsIgnoreCase(key)) {
                agentConfig.setEnterpriseId(value);
                continue;
            }
            if ("write-community".equalsIgnoreCase(key)) {
                agentConfig.setWriteCommunity(value);
                continue;
            }
            LOG.warn("Unexpected attribute in protocol configuration string for SnmpAgentConfig: '{}'", (Object)attribute);
        }
        return agentConfig;
    }

    public String toProtocolConfigString() {
        StringBuffer buff = new StringBuffer("snmp:");
        buff.append("address=").append(this.m_address == null ? null : InetAddrUtils.str(this.m_address));
        buff.append(",port=").append(this.getPort());
        buff.append(",timeout=").append(this.getTimeout());
        buff.append(",retries=").append(this.getRetries());
        buff.append(",max-vars-per-pdu=").append(this.getMaxVarsPerPdu());
        buff.append(",max-repetitions=").append(this.getMaxRepetitions());
        buff.append(",max-request-size=").append(this.getMaxRequestSize());
        buff.append(",version=").append(SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.isVersion3()) {
            buff.append(",security-level=").append(this.getSecurityLevel());
            buff.append(",security-name=").append(this.getSecurityName());
            buff.append(",auth-passphrase=").append(this.getAuthPassPhrase());
            buff.append(",auth-protocol=").append(this.getAuthProtocol());
            buff.append(",priv-passphrase=").append(this.getPrivPassPhrase());
            buff.append(",priv-protocol=").append(this.getPrivProtocol());
            if (this.getContextName() != null) {
                buff.append(",context-name=").append(this.getContextName());
            }
            if (this.getEngineId() != null) {
                buff.append(",engine-id=").append(this.getEngineId());
            }
            if (this.getContextEngineId() != null) {
                buff.append(",context-engine-id=").append(this.getContextEngineId());
            }
            if (this.getEnterpriseId() != null) {
                buff.append(",enterprise-id=").append(this.getEnterpriseId());
            }
        } else {
            buff.append(",read-community=").append(this.getReadCommunity());
            buff.append(",write-community=").append(this.getWriteCommunity());
        }
        return buff.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("SnmpAgentConfig[");
        buff.append("Address: ").append(this.m_address == null ? null : InetAddrUtils.str(this.m_address));
        buff.append(", ProxyForAddress: ").append(this.m_proxyFor == null ? null : InetAddrUtils.str(this.m_proxyFor));
        buff.append(", Port: ").append(this.getPort());
        buff.append(", Timeout: ").append(this.getTimeout());
        buff.append(", Retries: ").append(this.getRetries());
        buff.append(", MaxVarsPerPdu: ").append(this.getMaxVarsPerPdu());
        buff.append(", MaxRepetitions: ").append(this.getMaxRepetitions());
        buff.append(", MaxRequestSize: ").append(this.getMaxRequestSize());
        buff.append(", Version: ").append(SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.isVersion3()) {
            buff.append(", Security level: ").append(this.getSecurityLevel());
            buff.append(", Security name: ").append(this.getSecurityName());
            buff.append(", auth-passphrase: ").append(this.getAuthPassPhrase());
            buff.append(", auth-protocol: ").append(this.getAuthProtocol());
            buff.append(", priv-passphrase: ").append(this.getPrivPassPhrase());
            buff.append(", priv-protocol: ").append(this.getPrivProtocol());
            buff.append(", Context name: ").append(this.getContextName());
            buff.append(", Engine ID: ").append(this.getEngineId());
            buff.append(", Context Engine ID: ").append(this.getContextEngineId());
            buff.append(", Enterprise ID:").append(this.getEnterpriseId());
        } else {
            buff.append(", ReadCommunity: ").append(this.getReadCommunity());
            buff.append(", WriteCommunity: ").append(this.getWriteCommunity());
        }
        buff.append("]");
        return buff.toString();
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    @XmlJavaTypeAdapter(value=InetAddrXmlAdapter.class)
    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }

    @XmlTransient
    public InetAddress getEffectiveAddress() {
        if (this.m_proxyFor == null) {
            return this.m_address;
        }
        return this.m_proxyFor;
    }
}

