/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="snmp", name="walk", description="Walk the agent on the specified host and print the results.")
public class WalkCommand
extends OsgiCommandSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(WalkCommand.class);
    @Option(name="-v", aliases={"--version"}, description="SNMP version either 1, 2c or 3", required=true, multiValued=false)
    String m_version;
    @Option(name="-c", aliases={"--community"}, description="SNMP community string to use, defaults to 'public'", required=false, multiValued=false)
    String m_community = "public";
    @Option(name="-p", aliases={"--port"}, description="port to use to address the agent defaults to 161", required=false, multiValued=false)
    int m_port = 161;
    @Argument(index=0, name="host", description="hostname/ipAddress of the system to walk", required=true, multiValued=false)
    String m_host;
    @Argument(index=1, name="oids", description="list of objectIds to retrieve from the agent", required=true, multiValued=true)
    List<String> m_oids;

    private boolean validate() {
        return true;
    }

    protected Object doExecute() throws Exception {
        LOG.debug("snmp:walk -v {} -c {} -p {} {} {}", new Object[]{this.m_version, this.m_community, this.m_port, this.m_host, this.m_oids});
        if (!this.validate()) {
            return null;
        }
        SnmpAgentConfig config = new SnmpAgentConfig(InetAddress.getByName(this.m_host));
        config.setPort(this.m_port);
        config.setVersionAsString("v" + this.m_version);
        config.setReadCommunity(this.m_community);
        ArrayList<ColumnTracker> trackers = new ArrayList<ColumnTracker>();
        for (String oid : this.m_oids) {
            SnmpObjId objId = SnmpObjId.get((String)oid);
            ColumnTracker tracker = new ColumnTracker(objId);
            trackers.add(tracker);
        }
        AggregateTracker agg = new AggregateTracker(trackers){

            protected void storeResult(SnmpResult res) {
                System.out.printf("[%s].[%s] = %s%n", res.getBase(), res.getInstance(), res.getValue());
            }
        };
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)config, (String)"snmp:walk", (CollectionTracker)agg);
        walker.start();
        walker.waitFor();
        if (walker.timedOut()) {
            System.err.println("Timed Out");
        } else if (walker.failed()) {
            System.err.println(walker.getErrorMessage());
        }
        return null;
    }
}

