/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import org.apache.camel.impl.AnnotatedParameterConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.StringQuoteHelper;

public class ParameterConfiguration {
    private final String name;
    private final Class<?> parameterType;

    public ParameterConfiguration(String name, Class<?> parameterType) {
        this.name = name;
        this.parameterType = parameterType;
    }

    public String toString() {
        return "ParameterConfiguration[" + this.name + " on " + this.parameterType + "]";
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public static ParameterConfiguration newInstance(String name, Field field, UriParam uriParam) {
        return new AnnotatedParameterConfiguration(name, field.getType(), field);
    }

    public String toJson() {
        String typeName = this.parameterType.getCanonicalName();
        if (this.parameterType.isEnum()) {
            typeName = "string";
            CollectionStringBuffer sb = new CollectionStringBuffer();
            for (Object value : this.parameterType.getEnumConstants()) {
                sb.append(StringQuoteHelper.doubleQuote(value.toString()));
            }
            return StringQuoteHelper.doubleQuote(this.name) + ": { \"type\": " + StringQuoteHelper.doubleQuote(typeName) + ", \"enum\": [ " + sb.toString() + " ] }";
        }
        return StringQuoteHelper.doubleQuote(this.name) + ": { \"type\": " + StringQuoteHelper.doubleQuote(typeName) + " }";
    }
}

