/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.util.List;
import java.util.regex.Pattern;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.Field;

public abstract class EventMatchers {
    public static EventMatcher falseMatcher() {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                return false;
            }

            public String toString() {
                return "false";
            }
        };
    }

    public static EventMatcher trueMatcher() {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                return true;
            }

            public String toString() {
                return "true";
            }
        };
    }

    public static EventMatcher ueiMatcher(final String uei) {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                String matchingUei = matchingEvent.getUei();
                return matchingUei != null && uei.equals(matchingUei);
            }

            public String toString() {
                return "event.uei==" + uei;
            }
        };
    }

    public static EventMatcher and(final EventMatcher ... matchers) {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                for (EventMatcher matcher : matchers) {
                    if (matcher.matches(matchingEvent)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (EventMatcher matcher : matchers) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append("&&");
                    }
                    buf.append("(").append(matcher).append(")");
                }
                return buf.toString();
            }
        };
    }

    public static EventMatcher or(final EventMatcher ... matchers) {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                for (EventMatcher matcher : matchers) {
                    if (!matcher.matches(matchingEvent)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (EventMatcher matcher : matchers) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append("||");
                    }
                    buf.append("(").append(matcher).append(")");
                }
                return buf.toString();
            }
        };
    }

    public static Field varbind(final int vbnumber) {
        if (vbnumber <= 0) {
            throw new IllegalArgumentException("Invalid varbind index " + vbnumber + " must be 1 or greater.");
        }
        return new Field(){

            @Override
            public String get(Event event) {
                List parms = event.getParmCollection();
                return vbnumber > parms.size() ? null : EventConstants.getValueAsString((Value)((Parm)parms.get(vbnumber - 1)).getValue());
            }

            public String toString() {
                return "event.varbind#" + vbnumber;
            }
        };
    }

    public static Field field(String name) {
        if (name.equals("uei")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getUei();
                }
            };
        }
        if (name.equals("source")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSource();
                }
            };
        }
        if (name.equals("nodeid")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return Long.toString(event.getNodeid());
                }
            };
        }
        if (name.equals("host")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getHost();
                }
            };
        }
        if (name.equals("interface")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getInterface();
                }
            };
        }
        if (name.equals("snmphost")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmphost();
                }
            };
        }
        if (name.equals("service")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getService();
                }
            };
        }
        if (name.equals("id")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null ? null : event.getSnmp().getId();
                }
            };
        }
        if (name.equals("community")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null ? null : event.getSnmp().getCommunity();
                }
            };
        }
        if (name.equals("specific")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null || !event.getSnmp().hasSpecific() ? null : Integer.toString(event.getSnmp().getSpecific());
                }
            };
        }
        if (name.equals("generic")) {
            return new EventField(name){

                @Override
                public String get(Event event) {
                    return event.getSnmp() == null || !event.getSnmp().hasGeneric() ? null : Integer.toString(event.getSnmp().getGeneric());
                }
            };
        }
        throw new IllegalStateException("Field " + name + " is not understood!");
    }

    public static EventMatcher valueStartsWithMatcher(final Field field, final String value) {
        final String prefix = value.substring(0, value.length() - 1);
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                return eventValue != null && (eventValue.startsWith(prefix) || eventValue.equals(value));
            }

            public String toString() {
                return field + ".startsWith(" + prefix + ")";
            }
        };
    }

    public static EventMatcher valueMatchesRegexMatcher(final Field field, final String value) {
        final Pattern regex = Pattern.compile(value.startsWith("~") ? value.substring(1) : value);
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                return eventValue != null && (regex.matcher(eventValue).matches() || eventValue.equals(value));
            }

            public String toString() {
                return field + "~" + regex;
            }
        };
    }

    public static EventMatcher valueEqualsMatcher(final Field field, final String value) {
        return new EventMatcher(){

            @Override
            public boolean matches(Event matchingEvent) {
                String eventValue = field.get(matchingEvent);
                return eventValue != null && eventValue.equals(value);
            }

            public String toString() {
                return field + "==" + value;
            }
        };
    }

    private static abstract class EventField
    implements Field {
        private String m_name;

        public EventField(String name) {
            this.m_name = name;
        }

        public String toString() {
            return "event." + this.m_name;
        }

        @Override
        public abstract String get(Event var1);
    }
}

