/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd.jmx;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="mbeans")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Mbeans
implements Serializable {
    @XmlElement(name="mbean", required=true)
    private List<Mbean> _mbeanList = new ArrayList<Mbean>();

    public void addMbean(Mbean vMbean) throws IndexOutOfBoundsException {
        this._mbeanList.add(vMbean);
    }

    public void addMbean(int index, Mbean vMbean) throws IndexOutOfBoundsException {
        this._mbeanList.add(index, vMbean);
    }

    public Enumeration<Mbean> enumerateMbean() {
        return Collections.enumeration(this._mbeanList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mbeans) {
            Mbeans temp = (Mbeans)obj;
            if (this._mbeanList != null) {
                if (temp._mbeanList == null) {
                    return false;
                }
                if (!this._mbeanList.equals(temp._mbeanList)) {
                    return false;
                }
            } else if (temp._mbeanList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Mbean getMbean(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mbeanList.size()) {
            throw new IndexOutOfBoundsException("getMbean: Index value '" + index + "' not in range [0.." + (this._mbeanList.size() - 1) + "]");
        }
        return this._mbeanList.get(index);
    }

    public Mbean[] getMbean() {
        Mbean[] array = new Mbean[]{};
        return this._mbeanList.toArray(array);
    }

    public List<Mbean> getMbeanCollection() {
        return this._mbeanList;
    }

    public int getMbeanCount() {
        return this._mbeanList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._mbeanList != null) {
            result = 37 * result + this._mbeanList.hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Mbean> iterateMbean() {
        return this._mbeanList.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMbean() {
        this._mbeanList.clear();
    }

    public boolean removeMbean(Mbean vMbean) {
        boolean removed = this._mbeanList.remove(vMbean);
        return removed;
    }

    public Mbean removeMbeanAt(int index) {
        Mbean obj = this._mbeanList.remove(index);
        return obj;
    }

    public void setMbean(int index, Mbean vMbean) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mbeanList.size()) {
            throw new IndexOutOfBoundsException("setMbean: Index value '" + index + "' not in range [0.." + (this._mbeanList.size() - 1) + "]");
        }
        this._mbeanList.set(index, vMbean);
    }

    public void setMbean(Mbean[] vMbeanArray) {
        this._mbeanList.clear();
        for (int i = 0; i < vMbeanArray.length; ++i) {
            this._mbeanList.add(vMbeanArray[i]);
        }
    }

    public void setMbean(List<Mbean> vMbeanList) {
        this._mbeanList.clear();
        this._mbeanList.addAll(vMbeanList);
    }

    public void setMbeanCollection(List<Mbean> mbeanList) {
        this._mbeanList = mbeanList;
    }

    @Deprecated
    public static Mbeans unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Mbeans)Unmarshaller.unmarshal(Mbeans.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

