/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;

public class Policies {
    private static final ReconnectionPolicy DEFAULT_RECONNECTION_POLICY = new ExponentialReconnectionPolicy(1000L, 600000L);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = DefaultRetryPolicy.INSTANCE;
    private final LoadBalancingPolicy loadBalancingPolicy;
    private final ReconnectionPolicy reconnectionPolicy;
    private final RetryPolicy retryPolicy;

    public Policies() {
        this(Policies.defaultLoadBalancingPolicy(), Policies.defaultReconnectionPolicy(), Policies.defaultRetryPolicy());
    }

    public Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
        this.reconnectionPolicy = reconnectionPolicy;
        this.retryPolicy = retryPolicy;
    }

    public static LoadBalancingPolicy defaultLoadBalancingPolicy() {
        return new RoundRobinPolicy();
    }

    public static ReconnectionPolicy defaultReconnectionPolicy() {
        return DEFAULT_RECONNECTION_POLICY;
    }

    public static RetryPolicy defaultRetryPolicy() {
        return DEFAULT_RETRY_POLICY;
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public ReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }
}

