/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

public class Snmp4JWalker
extends SnmpWalker {
    private static final transient Logger LOG = LoggerFactory.getLogger(Snmp4JWalker.class);
    private Snmp m_session;
    private final Target m_tgt;
    private final ResponseListener m_listener;
    private final Snmp4JAgentConfig m_agentConfig;

    public Snmp4JWalker(Snmp4JAgentConfig agentConfig, String name, CollectionTracker tracker) {
        super(agentConfig.getInetAddress(), name, agentConfig.getMaxVarsPerPdu(), agentConfig.getMaxRepetitions(), tracker);
        this.m_agentConfig = agentConfig;
        this.m_tgt = agentConfig.getTarget();
        this.m_listener = new Snmp4JResponseListener();
    }

    public void start() {
        LOG.debug("Walking {} for {} using version {} with config: {}", new Object[]{this.getName(), this.getAddress(), this.m_agentConfig.getVersionString(), this.m_agentConfig});
        super.start();
    }

    protected SnmpWalker.WalkerPduBuilder createPduBuilder(int maxVarsPerPdu) {
        return this.getVersion() == 0 ? new GetNextBuilder(maxVarsPerPdu) : new GetBulkBuilder(maxVarsPerPdu);
    }

    protected void sendNextPdu(SnmpWalker.WalkerPduBuilder pduBuilder) throws IOException {
        Snmp4JPduBuilder snmp4JPduBuilder = (Snmp4JPduBuilder)pduBuilder;
        if (this.m_session == null) {
            this.m_session = this.m_agentConfig.createSnmpSession();
            this.m_session.listen();
        }
        LOG.debug("Sending tracker pdu of size {}", (Object)snmp4JPduBuilder.getPdu().size());
        this.m_session.send(snmp4JPduBuilder.getPdu(), this.m_tgt, null, this.m_listener);
    }

    protected int getVersion() {
        return this.m_tgt.getVersion();
    }

    public void close() throws IOException {
        if (this.m_session != null) {
            this.m_session.close();
            this.m_session = null;
        }
    }

    public class Snmp4JResponseListener
    implements ResponseListener {
        private void processResponse(PDU response) {
            try {
                LOG.debug("Received a tracker PDU of type {} from {} of size {}, errorStatus = {}, errorStatusText = {}, errorIndex = {}", new Object[]{PDU.getTypeString(response.getType()), Snmp4JWalker.this.getAddress(), response.size(), response.getErrorStatus(), response.getErrorStatusText(), response.getErrorIndex()});
                if (response.getType() == -88) {
                    Snmp4JWalker.this.handleAuthError("A REPORT PDU was returned from the agent.  This is most likely an authentication problem.  Please check the config");
                } else {
                    if (!Snmp4JWalker.this.processErrors(response.getErrorStatus(), response.getErrorIndex())) {
                        if (response.size() == 0) {
                            Snmp4JWalker.this.handleError("A PDU with no errors and 0 varbinds was returned from the agent at " + Snmp4JWalker.this.getAddress() + ". This seems to be related with a broken SNMP agent.");
                        } else {
                            for (int i = 0; i < response.size(); ++i) {
                                VariableBinding vb = response.get(i);
                                SnmpObjId receivedOid = SnmpObjId.get((int[])vb.getOid().getValue());
                                Snmp4JValue val = new Snmp4JValue(vb.getVariable());
                                Snmp4JWalker.this.processResponse(receivedOid, (SnmpValue)val);
                            }
                        }
                    }
                    Snmp4JWalker.this.buildAndSendNextPdu();
                }
            }
            catch (IOException e) {
                Snmp4JWalker.this.handleFatalError(e);
            }
            catch (RuntimeException e) {
                Snmp4JWalker.this.handleFatalError(e);
            }
        }

        @Override
        public void onResponse(ResponseEvent responseEvent) {
            Snmp4JWalker.this.m_session.cancel(responseEvent.getRequest(), this);
            if (responseEvent.getError() instanceof InterruptedException) {
                LOG.debug("Interruption event.  We have probably tried to close the session due to an error", (Throwable)responseEvent.getError());
            } else if (responseEvent.getResponse() == null) {
                Snmp4JWalker.this.handleTimeout(Snmp4JWalker.this.getName() + ": snmpTimeoutError for: " + Snmp4JWalker.this.getAddress());
            } else if (responseEvent.getError() != null) {
                Snmp4JWalker.this.handleError(Snmp4JWalker.this.getName() + ": snmpInternalError: " + responseEvent.getError() + " for: " + Snmp4JWalker.this.getAddress(), responseEvent.getError());
            } else {
                this.processResponse(responseEvent.getResponse());
            }
        }
    }

    public class GetBulkBuilder
    extends Snmp4JPduBuilder {
        private PDU m_bulkPdu;

        public GetBulkBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.reset();
        }

        public void reset() {
            this.m_bulkPdu = Snmp4JWalker.this.m_agentConfig.createPdu(-91);
        }

        @Override
        public PDU getPdu() {
            return this.m_bulkPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            VariableBinding varBind = new VariableBinding(new OID(snmpObjId.getIds()));
            this.m_bulkPdu.add(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
            this.m_bulkPdu.setNonRepeaters(numNonRepeaters);
        }

        public void setMaxRepetitions(int maxRepetitions) {
            this.m_bulkPdu.setMaxRepetitions(maxRepetitions);
        }
    }

    public class GetNextBuilder
    extends Snmp4JPduBuilder {
        private PDU m_nextPdu;

        private GetNextBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
            this.m_nextPdu = null;
            this.reset();
        }

        public void reset() {
            this.m_nextPdu = Snmp4JWalker.this.m_agentConfig.createPdu(-95);
        }

        @Override
        public PDU getPdu() {
            return this.m_nextPdu;
        }

        public void addOid(SnmpObjId snmpObjId) {
            VariableBinding varBind = new VariableBinding(new OID(snmpObjId.getIds()));
            this.m_nextPdu.add(varBind);
        }

        public void setNonRepeaters(int numNonRepeaters) {
        }

        public void setMaxRepetitions(int maxRepititions) {
        }
    }

    public static abstract class Snmp4JPduBuilder
    extends SnmpWalker.WalkerPduBuilder {
        public Snmp4JPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        public abstract PDU getPdu();
    }
}

