/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring;

import java.lang.reflect.Field;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.access.DefaultLocatorFactory;
import org.springframework.util.Assert;

public abstract class BeanUtils {
    public static final Logger LOG = LoggerFactory.getLogger(BeanUtils.class);

    public static BeanFactoryReference getBeanFactory(String contextId) {
        BeanFactoryLocator beanFactoryLoader = DefaultLocatorFactory.getInstance();
        return beanFactoryLoader.useBeanFactory(contextId);
    }

    public static <T> T getBean(BeanFactoryReference beanFactory, String beanId, Class<T> clazz) {
        return clazz.cast(beanFactory.getFactory().getBean(beanId));
    }

    public static <T> T getBean(String contextId, String beanId, Class<T> clazz) {
        return BeanUtils.getBean(BeanUtils.getBeanFactory(contextId), beanId, clazz);
    }

    public static <T> T getFactory(String contextId, Class<T> clazz) {
        return (T)BeanUtils.getBeanFactory(contextId).getFactory();
    }

    public static <T> void assertAutowiring(T instance) {
        for (Field field : instance.getClass().getDeclaredFields()) {
            Autowired autowired = field.getAnnotation(Autowired.class);
            Resource resource = field.getAnnotation(Resource.class);
            if ((autowired == null || !autowired.required()) && resource == null) continue;
            try {
                field.setAccessible(true);
                Assert.notNull((Object)field.get(instance), (String)("@Autowired/@Resource field " + field.getName() + " cannot be null"));
                LOG.debug("{} is not null", (Object)field.getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Illegal access to @Autowired/@Resource field " + field.getName());
            }
        }
    }
}

