/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class Vault {
    private static Properties properties = new Properties(System.getProperties());
    private static String homeDir = "/opt/opennms/";

    public static void setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Vault.properties = properties;
        Enumeration<Object> keys = properties.keys();
        Properties sysProps = System.getProperties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            sysProps.put(key, properties.get(key));
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setHomeDir(String homeDir) {
        if (homeDir == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Vault.homeDir = homeDir;
        properties.setProperty("opennms.home", homeDir);
        System.setProperty("opennms.home", homeDir);
    }

    public static String getHomeDir() {
        return homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supplementSystemPropertiesFromKey(String key) {
        boolean loadedOK = true;
        String path = System.getProperty(key);
        if (path != null) {
            StringTokenizer files = new StringTokenizer(path, File.pathSeparator);
            while (files.hasMoreTokens()) {
                try {
                    File pfile = new File(files.nextToken());
                    if (!pfile.exists() || !pfile.isFile()) continue;
                    Properties p = new Properties();
                    FileInputStream is = new FileInputStream(pfile);
                    try {
                        p.load(is);
                    }
                    finally {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ioE) {}
                    }
                    for (Map.Entry<Object, Object> e : p.entrySet()) {
                        if (System.getProperty((String)e.getKey()) != null) continue;
                        System.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                }
                catch (IOException ioE) {
                    loadedOK = false;
                }
            }
        }
        return loadedOK;
    }
}

