/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.slf4j.MDC;

public class LogPreservingThreadFactory
implements ThreadFactory {
    private final BitSet m_slotNumbers;
    private final String m_name;
    private final int m_poolSize;
    private Map m_mdc = null;
    private int m_counter = 0;

    public LogPreservingThreadFactory(String poolName, int poolSize, boolean preserveMDC) {
        this.m_name = poolName;
        this.m_poolSize = poolSize;
        BitSet bitSet = this.m_slotNumbers = poolSize < Integer.MAX_VALUE ? new BitSet(poolSize + 1) : new BitSet(1);
        if (preserveMDC) {
            this.m_mdc = MDC.getCopyOfContextMap();
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        if (this.m_poolSize == Integer.MAX_VALUE) {
            return this.getIncrementingThread(r);
        }
        if (this.m_poolSize > 1) {
            return this.getPooledThread(r);
        }
        return this.getSingleThread(r);
    }

    private Map getCopyOfContextMap() {
        return MDC.getCopyOfContextMap();
    }

    private void setContextMap(Map map) {
        if (map == null) {
            MDC.clear();
        } else {
            MDC.setContextMap((Map)map);
        }
    }

    private Thread getIncrementingThread(final Runnable r) {
        String name = String.format("%s-Thread-%d", this.m_name, ++this.m_counter);
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map mdc = LogPreservingThreadFactory.this.getCopyOfContextMap();
                try {
                    LogPreservingThreadFactory.this.setContextMap(LogPreservingThreadFactory.this.m_mdc);
                    r.run();
                }
                finally {
                    LogPreservingThreadFactory.this.setContextMap(mdc);
                }
            }
        }, name);
    }

    private Thread getSingleThread(final Runnable r) {
        String name = String.format("%s-Thread", this.m_name);
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map mdc = LogPreservingThreadFactory.this.getCopyOfContextMap();
                try {
                    LogPreservingThreadFactory.this.setContextMap(LogPreservingThreadFactory.this.m_mdc);
                    r.run();
                }
                finally {
                    LogPreservingThreadFactory.this.setContextMap(mdc);
                }
            }
        }, name);
    }

    private Thread getPooledThread(final Runnable r) {
        final int threadNumber = LogPreservingThreadFactory.getOpenThreadSlot(this.m_slotNumbers);
        String name = String.format("%s-Thread-%d-of-%d", this.m_name, threadNumber, this.m_poolSize);
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map mdc = LogPreservingThreadFactory.this.getCopyOfContextMap();
                try {
                    try {
                        LogPreservingThreadFactory.this.setContextMap(LogPreservingThreadFactory.this.m_mdc);
                        r.run();
                    }
                    finally {
                        LogPreservingThreadFactory.this.setContextMap(mdc);
                    }
                }
                finally {
                    BitSet bitSet = LogPreservingThreadFactory.this.m_slotNumbers;
                    synchronized (bitSet) {
                        LogPreservingThreadFactory.this.m_slotNumbers.set(threadNumber, false);
                    }
                }
            }
        }, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getOpenThreadSlot(BitSet bs) {
        BitSet bitSet = bs;
        synchronized (bitSet) {
            for (int i = 1; i < bs.size(); ++i) {
                if (bs.get(i)) continue;
                bs.set(i, true);
                return i;
            }
            return 0;
        }
    }
}

