/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventUtils;

public class DeleteEventVisitor
extends AbstractEntityVisitor {
    private final EventForwarder m_eventForwarder;
    private static final String m_eventSource = "Provisiond";

    public DeleteEventVisitor(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    @Override
    public void visitMonitoredServiceComplete(OnmsMonitoredService monSvc) {
        this.m_eventForwarder.sendNow(EventUtils.createServiceDeletedEvent(m_eventSource, monSvc.getNodeId(), monSvc.getIpAddress(), monSvc.getServiceType().getName()));
    }

    @Override
    public void visitIpInterfaceComplete(OnmsIpInterface iface) {
        this.m_eventForwarder.sendNow(EventUtils.createInterfaceDeletedEvent(m_eventSource, iface.getNode().getId(), iface.getIpAddress()));
    }

    @Override
    public void visitNodeComplete(OnmsNode node) {
        this.m_eventForwarder.sendNow(EventUtils.createNodeDeletedEvent(m_eventSource, node.getId(), node.getLabel(), node.getLabel()));
    }
}

