/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="stpNode")
@Entity
@Table(name="stpNode", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "baseVlan"})})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsStpNode {
    private Integer m_id;
    private OnmsNode m_node;
    private String m_baseBridgeAddress;
    private Integer m_baseNumPorts;
    private BridgeBaseType m_baseType;
    private StpProtocolSpecification m_stpProtocolSpecification;
    private Integer m_stpPriority;
    private String m_stpDesignatedRoot;
    private Integer m_stpRootCost;
    private Integer m_stpRootPort;
    private OnmsArpInterface.StatusType m_status = OnmsArpInterface.StatusType.UNKNOWN;
    private Date m_lastPollTime;
    private Integer m_baseVlan;
    private String m_baseVlanName;

    public OnmsStpNode() {
    }

    public OnmsStpNode(OnmsNode node, Integer vlanIndex) {
        this.m_node = node;
        this.m_baseVlan = vlanIndex;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlElement
    @Column(length=12, nullable=false)
    public String getBaseBridgeAddress() {
        return this.m_baseBridgeAddress;
    }

    public void setBaseBridgeAddress(String baseBridgeAddress) {
        this.m_baseBridgeAddress = baseBridgeAddress;
    }

    @XmlElement
    @Column
    public Integer getBaseNumPorts() {
        return this.m_baseNumPorts;
    }

    public void setBaseNumPorts(Integer baseNumPorts) {
        this.m_baseNumPorts = baseNumPorts;
    }

    @XmlElement
    @Column
    public BridgeBaseType getBaseType() {
        return this.m_baseType;
    }

    public void setBaseType(BridgeBaseType baseType) {
        this.m_baseType = baseType;
    }

    @XmlElement
    @Column
    public StpProtocolSpecification getStpProtocolSpecification() {
        return this.m_stpProtocolSpecification;
    }

    public void setStpProtocolSpecification(StpProtocolSpecification stpProtocolSpecification) {
        this.m_stpProtocolSpecification = stpProtocolSpecification;
    }

    @XmlElement
    @Column
    public Integer getStpPriority() {
        return this.m_stpPriority;
    }

    public void setStpPriority(Integer stpPriority) {
        this.m_stpPriority = stpPriority;
    }

    @XmlElement
    @Column(length=16)
    public String getStpDesignatedRoot() {
        return this.m_stpDesignatedRoot;
    }

    public void setStpDesignatedRoot(String stpDesignatedRoot) {
        this.m_stpDesignatedRoot = stpDesignatedRoot;
    }

    @XmlElement
    @Column
    public Integer getStpRootCost() {
        return this.m_stpRootCost;
    }

    public void setStpRootCost(Integer stpRootCost) {
        this.m_stpRootCost = stpRootCost;
    }

    @XmlElement
    @Column
    public Integer getStpRootPort() {
        return this.m_stpRootPort;
    }

    public void setStpRootPort(Integer stpRootPort) {
        this.m_stpRootPort = stpRootPort;
    }

    @XmlAttribute
    @Column(nullable=false)
    public OnmsArpInterface.StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(OnmsArpInterface.StatusType status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlElement
    @Column(nullable=false)
    public Integer getBaseVlan() {
        return this.m_baseVlan;
    }

    public void setBaseVlan(Integer baseVlan) {
        this.m_baseVlan = baseVlan;
    }

    @XmlElement
    @Column(length=32)
    public String getBaseVlanName() {
        return this.m_baseVlanName;
    }

    public void setBaseVlanName(String baseVlanName) {
        this.m_baseVlanName = baseVlanName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.m_id).append("node", (Object)this.m_node).append("baseBridgeAddress", (Object)this.m_baseBridgeAddress).append("baseNumPorts", (Object)this.m_baseNumPorts).append("baseType", (Object)this.m_baseType).append("stpProtocolSpecification", (Object)this.m_stpProtocolSpecification).append("stpPriority", (Object)this.m_stpPriority).append("stpDesignatedRoot", (Object)this.m_stpDesignatedRoot).append("stpRootCost", (Object)this.m_stpRootCost).append("stpRootPort", (Object)this.m_stpRootPort).append("status", (Object)this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).append("baseVlan", (Object)this.m_baseVlan).append("baseVlanName", (Object)this.m_baseVlanName).toString();
    }

    @Embeddable
    public static class StpProtocolSpecification
    implements Comparable<StpProtocolSpecification>,
    Serializable {
        private static final long serialVersionUID = -1815947324977781143L;
        public static final int STP_PROTOCOL_SPECIFICATION_UNKNOWN = 1;
        public static final int STP_PROTOCOL_SPECIFICATION_DECLB100 = 2;
        public static final int STP_PROTOCOL_SPECIFICATION_IEEE8021D = 3;
        private static final Integer[] s_order = new Integer[]{1, 2, 3};
        private Integer m_stpprotocolspecification;
        private static final Map<Integer, String> stpProtocolSpecificationMap = new HashMap<Integer, String>();
        public static StpProtocolSpecification UNKNOWN;
        public static StpProtocolSpecification DECLB100;
        public static StpProtocolSpecification IEEE8021D;

        private StpProtocolSpecification() {
        }

        public StpProtocolSpecification(Integer stpprotocolspecification) {
            this.m_stpprotocolspecification = stpprotocolspecification;
        }

        @Column(name="stpProtocolSpecification")
        public Integer getIntCode() {
            return this.m_stpprotocolspecification;
        }

        public void setIntCode(Integer stpProtocolSpecification) {
            this.m_stpprotocolspecification = stpProtocolSpecification;
        }

        @Override
        public int compareTo(StpProtocolSpecification o) {
            return StpProtocolSpecification.getIndex(this.m_stpprotocolspecification) - StpProtocolSpecification.getIndex(o.m_stpprotocolspecification);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal StpProtocolSpecification code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof StpProtocolSpecification) {
                return this.m_stpprotocolspecification.intValue() == ((StpProtocolSpecification)o).m_stpprotocolspecification.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_stpprotocolspecification);
        }

        public static StpProtocolSpecification get(Integer code) {
            if (code == null) {
                return UNKNOWN;
            }
            switch (code) {
                case 1: {
                    return UNKNOWN;
                }
                case 2: {
                    return DECLB100;
                }
                case 3: {
                    return IEEE8021D;
                }
            }
            throw new IllegalArgumentException("Cannot create StpProtocolSpecification from code " + code);
        }

        public static String getStpProtocolSpecificationString(Integer code) {
            if (stpProtocolSpecificationMap.containsKey(code)) {
                return stpProtocolSpecificationMap.get(code);
            }
            return null;
        }

        static {
            stpProtocolSpecificationMap.put(1, "unknown");
            stpProtocolSpecificationMap.put(2, "decLb100");
            stpProtocolSpecificationMap.put(3, "ieee8021d");
            UNKNOWN = new StpProtocolSpecification(1);
            DECLB100 = new StpProtocolSpecification(2);
            IEEE8021D = new StpProtocolSpecification(3);
        }
    }

    @Embeddable
    public static class BridgeBaseType
    implements Comparable<BridgeBaseType>,
    Serializable {
        private static final long serialVersionUID = 4211573691385106051L;
        public static final int BASE_TYPE_UNKNOWN = 1;
        public static final int BASE_TYPE_TRANSPARENT_ONLY = 2;
        public static final int BASE_TYPE_SOURCEROUTE_ONLY = 3;
        public static final int BASE_TYPE_SRT = 4;
        private static final Integer[] s_order = new Integer[]{1, 2, 3, 4};
        private Integer m_basebridgetype;
        private static final Map<Integer, String> baseBridgeTypeMap = new HashMap<Integer, String>();
        public static final BridgeBaseType UNKNOWN;
        public static final BridgeBaseType TRANSPARENT_ONLY;
        public static final BridgeBaseType SOURCEROUTE_ONLY;
        public static final BridgeBaseType SRT;

        private BridgeBaseType() {
        }

        public BridgeBaseType(Integer bridgeBaseType) {
            this.m_basebridgetype = bridgeBaseType;
        }

        @Column(name="baseType")
        public Integer getIntCode() {
            return this.m_basebridgetype;
        }

        public void setIntCode(Integer baseBridgeType) {
            this.m_basebridgetype = baseBridgeType;
        }

        @Override
        public int compareTo(BridgeBaseType o) {
            return BridgeBaseType.getIndex(this.m_basebridgetype) - BridgeBaseType.getIndex(o.m_basebridgetype);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal baseBridgeType code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof BridgeBaseType) {
                return this.m_basebridgetype.intValue() == ((BridgeBaseType)o).m_basebridgetype.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_basebridgetype);
        }

        public static BridgeBaseType get(Integer code) {
            if (code == null) {
                return UNKNOWN;
            }
            switch (code) {
                case 1: {
                    return UNKNOWN;
                }
                case 2: {
                    return TRANSPARENT_ONLY;
                }
                case 3: {
                    return SOURCEROUTE_ONLY;
                }
                case 4: {
                    return SRT;
                }
            }
            throw new IllegalArgumentException("Cannot create BridgeBaseType from code " + code);
        }

        public static String getBridgeBaseTypeString(Integer code) {
            if (baseBridgeTypeMap.containsKey(code)) {
                return baseBridgeTypeMap.get(code);
            }
            return null;
        }

        static {
            baseBridgeTypeMap.put(1, "unknown");
            baseBridgeTypeMap.put(2, "transparent-only");
            baseBridgeTypeMap.put(3, "sourceroute-only");
            baseBridgeTypeMap.put(4, "srt");
            UNKNOWN = new BridgeBaseType(1);
            TRANSPARENT_ONLY = new BridgeBaseType(2);
            SOURCEROUTE_ONLY = new BridgeBaseType(3);
            SRT = new BridgeBaseType(4);
        }
    }
}

