/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsMap;

@XmlRootElement(name="mapElement")
@Entity
@Table(name="element")
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsMapElement
implements Serializable {
    public static final String MAP_TYPE = "M";
    public static final String MAP_HIDE_TYPE = "W";
    public static final String NODE_TYPE = "N";
    public static final String NODE_HIDE_TYPE = "H";
    public static final String defaultNodeIcon = "unspecified";
    public static final String defaultMapIcon = "map";
    private static final long serialVersionUID = 1594163211618494443L;
    private int id;
    private int elementId;
    private OnmsMap map;
    private String label;
    private String iconName;
    private int x;
    private int y;
    protected String type;

    protected OnmsMapElement() {
    }

    public OnmsMapElement(OnmsMapElement e) {
        this(e.map, e.elementId, e.type, e.label, e.iconName, e.x, e.y, e.id);
    }

    public OnmsMapElement(OnmsMap map, int elementId, String type, String label, String iconName, int x, int y, int id) {
        this.map = map;
        this.id = id;
        this.elementId = elementId;
        this.setType(type);
        this.label = label;
        this.setIconName(iconName);
        this.x = x;
        this.y = y;
    }

    public OnmsMapElement(OnmsMap map, int elementId, String type, String label, String iconName, int x, int y) {
        this.map = map;
        this.elementId = elementId;
        this.setType(type);
        this.label = label;
        this.setIconName(iconName);
        this.x = x;
        this.y = y;
    }

    @XmlTransient
    @Id
    @Column(name="id", nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @XmlID
    @Transient
    public String getMapElementId() {
        return Integer.toString(this.id);
    }

    @Column(name="elementId")
    public int getElementId() {
        return this.elementId;
    }

    public void setElementId(int elementId) {
        this.elementId = elementId;
    }

    @Column(name="elementType")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(MAP_TYPE) || type.equals(NODE_TYPE) || type.equals(NODE_HIDE_TYPE) || type.equals(MAP_HIDE_TYPE)) {
            this.type = type;
        }
    }

    @Column(name="elementLabel")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="elementIcon")
    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        if (iconName == null) {
            iconName = defaultNodeIcon;
        }
        this.iconName = iconName;
    }

    @Column(name="elementX")
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    @Column(name="elementY")
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="mapId")
    @XmlIDREF
    @XmlTransient
    public OnmsMap getMap() {
        return this.map;
    }

    public void setMap(OnmsMap map) {
        this.map = map;
    }
}

