/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlIDREF;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.DataLinkInterface;

@Entity
@Table(name="linkstate")
public class OnmsLinkState
implements Serializable,
Comparable<OnmsLinkState> {
    private static final long serialVersionUID = -5586375063168201398L;
    private Integer m_id;
    private DataLinkInterface m_dataLinkInterface;
    private LinkState m_linkState = LinkState.LINK_UP;

    public OnmsLinkState() {
    }

    public OnmsLinkState(DataLinkInterface dataLinkInterface, LinkState linkState) {
        this.m_dataLinkInterface = dataLinkInterface;
        this.m_linkState = linkState;
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @XmlIDREF
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="datalinkinterfaceid")
    public DataLinkInterface getDataLinkInterface() {
        return this.m_dataLinkInterface;
    }

    public void setDataLinkInterface(DataLinkInterface dataLinkInterface) {
        this.m_dataLinkInterface = dataLinkInterface;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="linkstate", length=24, nullable=false)
    public LinkState getLinkState() {
        return this.m_linkState;
    }

    public void setLinkState(LinkState linkState) {
        this.m_linkState = linkState;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("datalink interface", (Object)this.getDataLinkInterface()).append("link state", (Object)this.getLinkState()).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof OnmsLinkState) {
            OnmsLinkState lso = (OnmsLinkState)o;
            return new EqualsBuilder().append((Object)this.getId(), (Object)lso.getId()).append((Object)this.getDataLinkInterface(), (Object)lso.getDataLinkInterface()).append((Object)this.getLinkState(), (Object)lso.getLinkState()).isEquals();
        }
        return false;
    }

    @Override
    public int compareTo(OnmsLinkState o) {
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).append((Object)this.getDataLinkInterface(), (Object)o.getDataLinkInterface()).append((Object)this.getLinkState(), (Object)o.getLinkState()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).append((Object)this.getDataLinkInterface()).append((Object)this.getLinkState()).toHashCode();
    }

    public static enum LinkState {
        LINK_UP{

            @Override
            public LinkState nodeDown(LinkStateTransition transition) {
                transition.onLinkDown();
                return LINK_NODE_DOWN;
            }

            @Override
            public LinkState parentNodeDown(LinkStateTransition transition) {
                transition.onLinkDown();
                return LINK_PARENT_NODE_DOWN;
            }

            @Override
            public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_NODE_UNMANAGED;
            }

            @Override
            public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_PARENT_NODE_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "G";
            }
        }
        ,
        LINK_NODE_DOWN{

            @Override
            public LinkState nodeUp(LinkStateTransition transition) {
                transition.onLinkUp();
                return LINK_UP;
            }

            @Override
            public LinkState parentNodeDown(LinkStateTransition transition) {
                return LINK_BOTH_DOWN;
            }

            @Override
            public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_NODE_UNMANAGED;
            }

            @Override
            public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_PARENT_NODE_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "B";
            }
        }
        ,
        LINK_PARENT_NODE_DOWN{

            @Override
            public LinkState nodeDown(LinkStateTransition transition) {
                return LINK_BOTH_DOWN;
            }

            @Override
            public LinkState parentNodeUp(LinkStateTransition transition) {
                transition.onLinkUp();
                return LINK_UP;
            }

            @Override
            public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_NODE_UNMANAGED;
            }

            @Override
            public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_PARENT_NODE_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "B";
            }
        }
        ,
        LINK_BOTH_DOWN{

            @Override
            public LinkState nodeUp(LinkStateTransition transition) {
                return LINK_PARENT_NODE_DOWN;
            }

            @Override
            public LinkState parentNodeUp(LinkStateTransition transition) {
                return LINK_NODE_DOWN;
            }

            @Override
            public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_NODE_UNMANAGED;
            }

            @Override
            public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
                transition.onLinkUnknown();
                return LINK_PARENT_NODE_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "B";
            }
        }
        ,
        LINK_BOTH_UNMANAGED{

            @Override
            public LinkState nodeEndPointFound(LinkStateTransition transition) {
                return LINK_PARENT_NODE_UNMANAGED;
            }

            @Override
            public LinkState parentNodeEndPointFound(LinkStateTransition transition) {
                return LINK_NODE_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "U";
            }
        }
        ,
        LINK_PARENT_NODE_UNMANAGED{

            @Override
            public LinkState parentNodeEndPointFound(LinkStateTransition transition) {
                transition.onLinkUp();
                return LINK_UP;
            }

            @Override
            public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
                return LINK_BOTH_UNMANAGED;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "U";
            }
        }
        ,
        LINK_NODE_UNMANAGED{

            @Override
            public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
                return LINK_BOTH_UNMANAGED;
            }

            @Override
            public LinkState nodeEndPointFound(LinkStateTransition transition) {
                transition.onLinkUp();
                return LINK_UP;
            }

            @Override
            public String getDataLinkInterfaceStateType() {
                return "U";
            }
        };


        public abstract String getDataLinkInterfaceStateType();

        public LinkState nodeDown(LinkStateTransition transition) {
            return this;
        }

        public LinkState parentNodeDown(LinkStateTransition transition) {
            return this;
        }

        public LinkState nodeUp(LinkStateTransition transition) {
            return this;
        }

        public LinkState parentNodeUp(LinkStateTransition transition) {
            return this;
        }

        public LinkState down(boolean isParent, LinkStateTransition transition) {
            return isParent ? this.parentNodeDown(transition) : this.nodeDown(transition);
        }

        public LinkState up(boolean isParent, LinkStateTransition transition) {
            return isParent ? this.parentNodeUp(transition) : this.nodeUp(transition);
        }

        public LinkState nodeEndPointFound(LinkStateTransition transition) {
            return this;
        }

        public LinkState parentNodeEndPointFound(LinkStateTransition transition) {
            return this;
        }

        public LinkState parentNodeEndPointDeleted(LinkStateTransition transition) {
            return this;
        }

        public LinkState nodeEndPointDeleted(LinkStateTransition transition) {
            return this;
        }
    }

    public static interface LinkStateTransition {
        public void onLinkUp();

        public void onLinkDown();

        public void onLinkUnknown();
    }
}

