/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

@Embeddable
public class OnmsGeolocation
implements Serializable {
    private static final long serialVersionUID = -3346555393433178515L;
    private String m_address1;
    private String m_address2;
    private String m_city;
    private String m_state;
    private String m_zip;
    private String m_country;
    private Float m_longitude;
    private Float m_latitude;

    @Column(name="address1", length=256)
    public String getAddress1() {
        return this.m_address1;
    }

    public void setAddress1(String address1) {
        this.m_address1 = address1;
    }

    @Column(name="address2", length=256)
    public String getAddress2() {
        return this.m_address2;
    }

    public void setAddress2(String address2) {
        this.m_address2 = address2;
    }

    @Column(name="city", length=64)
    public String getCity() {
        return this.m_city;
    }

    public void setCity(String city) {
        this.m_city = city;
    }

    @Column(name="state", length=64)
    public String getState() {
        return this.m_state;
    }

    public void setState(String state) {
        this.m_state = state;
    }

    @Column(name="zip", length=64)
    public String getZip() {
        return this.m_zip;
    }

    public void setZip(String zip) {
        this.m_zip = zip;
    }

    @Column(name="country", length=64)
    public String getCountry() {
        return this.m_country;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    @Column(name="longitude")
    public Float getLongitude() {
        return this.m_longitude;
    }

    public void setLongitude(Float longitude) {
        this.m_longitude = longitude;
    }

    @Column(name="latitude")
    public Float getLatitude() {
        return this.m_latitude;
    }

    public void setLatitude(Float latitude) {
        this.m_latitude = latitude;
    }

    public String toString() {
        return "OnmsGeolocation[" + this.asAddressString() + "]";
    }

    public String asAddressString() {
        StringBuffer sb = new StringBuffer();
        if (this.hasText(this.getAddress1())) {
            sb.append(this.getAddress1());
            if (this.hasText(this.getAddress2())) {
                sb.append(" ").append(this.getAddress2());
            }
        }
        if (this.hasText(this.getCity())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getCity());
        }
        if (this.hasText(this.getState())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getState());
        }
        if (this.hasText(this.getZip())) {
            if (this.hasText(this.getState())) {
                sb.append(" ");
            } else if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getZip());
        }
        if (this.hasText(this.getCountry())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.getCountry());
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private boolean hasText(String string) {
        return string != null && !string.isEmpty() && !string.trim().isEmpty();
    }

    public void mergeGeolocation(OnmsGeolocation from) {
        PropertyDescriptor[] pds;
        if (from == null) {
            return;
        }
        BeanWrapper toBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
        BeanWrapper fromBean = PropertyAccessorFactory.forBeanPropertyAccess((Object)from);
        for (PropertyDescriptor pd : pds = fromBean.getPropertyDescriptors()) {
            Object propertyValue;
            String propertyName = pd.getName();
            if (propertyName.equals("class") || (propertyValue = fromBean.getPropertyValue(propertyName)) == null) continue;
            toBean.setPropertyValue(propertyName, propertyValue);
        }
    }
}

