/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.controller.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.opennms.minion.api.MinionController;
import org.opennms.minion.api.MinionException;
import org.opennms.minion.api.MinionMessage;
import org.opennms.minion.api.MinionMessageReceiver;
import org.opennms.minion.api.MinionMessageSender;
import org.opennms.minion.api.MinionStatusMessage;
import org.opennms.minion.impl.MinionInitializationMessageImpl;
import org.opennms.minion.impl.MinionStatusMessageImpl;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionControllerImpl
implements MinionController,
MinionMessageReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(MinionControllerImpl.class);
    private AdminService m_adminService;
    private ConfigurationAdmin m_configurationAdmin;
    private String m_brokerUri;
    private String m_sendQueueName;
    private String m_id;
    private String m_location;
    private CamelContext m_camelContext;
    private ProducerTemplate m_producer;
    private MinionMessageSender m_messageSender;
    private MinionMessageReceiver m_messageReceiver;

    public void start() throws MinionException {
        String location;
        LOG.debug("Initializing controller.");
        assert (this.m_configurationAdmin != null) : "ConfigurationAdmin is missing!";
        assert (this.m_adminService != null) : "AdminService is missing!";
        assert (this.m_brokerUri != null) : "Broker URI is missing!";
        assert (this.m_sendQueueName != null) : "Sending queue name is missing!";
        this.m_id = this.loadProperty("id");
        if (this.m_id == null) {
            this.m_id = UUID.randomUUID().toString();
            this.saveProperty("id", this.m_id);
        }
        if ((location = (this.m_location = this.loadProperty("location"))) == null) {
            throw new MinionException("Location is not set!  Please make sure you set location='Location Name' in the org.opennms.minion.controller configuration.");
        }
        this.assertCamelContextExists();
        this.sendStartMessage();
        LOG.debug("MinionController initialized. ID is {}.", (Object)this.m_id);
    }

    public void stop() throws MinionException {
        LOG.debug("MinionController shutting down.");
        this.sendStopMessage();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        ArrayList<MinionException> rethrow = new ArrayList<MinionException>();
        if (this.m_producer != null) {
            try {
                this.m_producer.stop();
                this.m_producer = null;
            }
            catch (Exception e) {
                rethrow.add(new MinionException("Failed to shut down producer " + this.m_producer, (Throwable)e));
            }
        }
        if (this.m_camelContext != null) {
            try {
                ShutdownStrategy s = this.m_camelContext.getShutdownStrategy();
                s.shutdown(this.m_camelContext, this.m_camelContext.getRouteStartupOrder());
                this.m_camelContext.stop();
                this.m_camelContext = null;
            }
            catch (Exception e) {
                rethrow.add(new MinionException("Failed to shut down the Camel contxt cleanly.", (Throwable)e));
            }
        }
        if (rethrow.size() > 0) {
            for (int i = 0; i < rethrow.size(); ++i) {
                MinionException e = (MinionException)rethrow.get(i);
                LOG.error("stop() failed; error #{}: {}", new Object[]{i, e.getMessage(), e});
            }
            throw (MinionException)rethrow.get(0);
        }
    }

    public void sendStartMessage() throws MinionException {
        this.assertMessageSenderExists();
        this.m_messageSender.sendMessage((MinionMessage)this.createStatusMessage(null));
    }

    public void sendStopMessage() throws MinionException {
        this.assertMessageSenderExists();
        this.m_messageSender.sendMessage((MinionMessage)this.createStatusMessage("Stopped"));
    }

    protected void assertMessageSenderExists() throws MinionException {
        if (this.m_messageSender == null) {
            assert (this.m_camelContext != null) : "Can't create a message sender without a camel context!";
            this.m_producer = this.m_camelContext.createProducerTemplate();
            this.m_messageSender = new MinionMessageSender(){

                public void sendMessage(MinionMessage message) throws MinionException {
                    MinionControllerImpl.this.m_producer.asyncRequestBody("direct:sendMessage", (Object)message);
                }
            };
        }
    }

    public String getId() throws MinionException {
        return this.m_id;
    }

    public String getLocation() throws MinionException {
        return this.m_location;
    }

    public void onMessage(MinionMessage message) throws MinionException {
        LOG.debug("Got minion message: {}", (Object)message);
    }

    protected void assertMessageReceiverExists() {
        if (this.m_messageReceiver == null) {
            this.m_messageReceiver = this;
        }
    }

    protected void assertCamelContextExists() throws MinionException {
        JaxbDataFormat df;
        if (this.m_camelContext != null) {
            return;
        }
        ActiveMQComponent activemq = new ActiveMQComponent();
        activemq.setBrokerURL(this.m_brokerUri);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MinionStatusMessageImpl.class, MinionInitializationMessageImpl.class});
            df = new JaxbDataFormat(context);
        }
        catch (JAXBException e) {
            String errorMessage = "Failed to create JAXB context for the minion controller!";
            LOG.error("Failed to create JAXB context for the minion controller!", (Throwable)e);
            throw new MinionException("Failed to create JAXB context for the minion controller!", (Throwable)e);
        }
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.setName("minion-controller");
        try {
            camelContext.addComponent("activemq", (Component)activemq);
            camelContext.addRoutes((RoutesBuilder)new RouteBuilder((DataFormat)df){
                final /* synthetic */ DataFormat val$df;
                {
                    this.val$df = dataFormat;
                }

                public void configure() throws Exception {
                    ((RouteDefinition)((RouteDefinition)this.from("direct:sendMessage").routeId("sendMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "minion-controller: sendMinionMessage: ${body.toString()}")).marshal(this.val$df)).to("activemq:" + MinionControllerImpl.this.m_sendQueueName + "?disableReplyTo=true");
                    MinionControllerImpl.this.assertMessageReceiverExists();
                    ((RouteDefinition)((RouteDefinition)this.from("activemq:control-" + MinionControllerImpl.this.m_id).routeId("receiveMinionMessage").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).log(LoggingLevel.DEBUG, "minion-controller: receiveMinionMessage: ${body}")).unmarshal(this.val$df)).bean((Object)MinionControllerImpl.this.m_messageReceiver, "onMessage");
                }
            });
            camelContext.start();
            int waitfor = 30;
            while (!camelContext.isStarted() && waitfor-- > 0) {
                LOG.debug("Waiting for camel context to start...");
                Thread.sleep(1000L);
            }
            this.m_camelContext = camelContext;
        }
        catch (Exception e) {
            throw new MinionException("Failed to configure routes for minion-controller context!", (Throwable)e);
        }
    }

    public MinionStatusMessage createStatusMessage(String withStatus) throws MinionException {
        MinionStatusMessageImpl minionStatus = new MinionStatusMessageImpl(this.m_id, Integer.valueOf(1));
        String status = withStatus;
        if (withStatus == null) {
            Instance rootInstance = null;
            for (Instance instance : this.m_adminService.getInstances()) {
                if (!instance.isRoot()) continue;
                rootInstance = instance;
                break;
            }
            if (rootInstance == null) {
                throw new MinionException("Unable to find root Karaf instance!");
            }
            try {
                status = rootInstance.getState();
            }
            catch (Exception e) {
                throw new MinionException("Failed to get state from the root instance.", (Throwable)e);
            }
        }
        minionStatus.setLocation(this.m_location);
        minionStatus.setStatus(status);
        minionStatus.setDate(new Date());
        return minionStatus;
    }

    protected String loadProperty(String propName) throws MinionException {
        Configuration config = this.getConfiguration();
        Dictionary properties = config.getProperties();
        if (properties == null) {
            return null;
        }
        String property = (String)properties.get(propName);
        return property;
    }

    protected void saveProperty(String key, String value) throws MinionException {
        Configuration config = this.getConfiguration();
        Dictionary properties = config.getProperties() == null ? new Hashtable() : config.getProperties();
        properties.put(key, value);
        try {
            config.update(properties);
        }
        catch (IOException e) {
            MinionException ce = new MinionException("Failed to update configuration.", (Throwable)e);
            LOG.error("Failed to update configuration.", (Throwable)e);
            throw ce;
        }
    }

    protected Configuration getConfiguration() throws MinionException {
        try {
            Configuration configuration = this.m_configurationAdmin.getConfiguration("org.opennms.minion.controller");
            if (configuration == null) {
                MinionException e = new MinionException("The OSGi configuration (admin) registry was found for pid org.opennms.minion.controller, but a configuration could not be located/generated.  This shouldn't happen.");
                LOG.error("Error getting configuration.", (Throwable)e);
                throw e;
            }
            return configuration;
        }
        catch (IOException e) {
            MinionException ce = new MinionException("Failed to get configuration from OSGi configuration registry for pid org.opennms.minion.controller.", (Throwable)e);
            LOG.error("Error getting configuration.", (Throwable)e);
            throw new MinionException((Throwable)ce);
        }
    }

    public void setAdminService(AdminService adminService) {
        this.m_adminService = adminService;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.m_configurationAdmin = configurationAdmin;
    }

    public void setMessageSender(MinionMessageSender sender) {
        this.m_messageSender = sender;
    }

    public void setMessageReceiver(MinionMessageReceiver receiver) {
        this.m_messageReceiver = receiver;
    }

    public void setCamelContext(CamelContext context) {
        this.m_camelContext = context;
    }

    public void setBrokerUri(String brokerUri) {
        this.m_brokerUri = brokerUri;
    }

    public void setSendQueueName(String queue) {
        this.m_sendQueueName = queue;
    }
}

