/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.api;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private final ThreadLocal<DateFormat> m_dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };

    public Date unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        return this.m_dateFormat.get().parse(v);
    }

    public String marshal(Date v) throws Exception {
        if (v == null) {
            return null;
        }
        return this.m_dateFormat.get().format(v);
    }
}

