/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.sampler.storage.rrd;

import java.util.Collections;
import java.util.Date;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleProcessorBuilder;
import org.opennms.netmgt.api.sample.SampleRepository;
import org.opennms.netmgt.api.sample.SampleSet;
import org.opennms.netmgt.api.sample.Timestamp;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.OneToOnePersister;
import org.opennms.netmgt.collection.sampler.SamplerCollectionAttribute;
import org.opennms.netmgt.collection.sampler.SamplerCollectionAttributeType;
import org.opennms.netmgt.collection.sampler.SamplerCollectionResource;
import org.opennms.netmgt.collection.sampler.SamplerCollectionSet;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdSampleRepository
implements SampleRepository {
    private static final Logger LOG = LoggerFactory.getLogger(RrdSampleRepository.class);
    private RrdRepository m_repo;

    public void save(SampleSet sampleSet) {
        SamplerCollectionSet collectionSet = new SamplerCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        RrdRepository repository = this.getRrdRepository();
        OneToOnePersister persister = new OneToOnePersister(new ServiceParameters(Collections.emptyMap()), repository);
        for (Resource resource : sampleSet.getResources()) {
            SamplerCollectionResource collectionResource = new SamplerCollectionResource(resource, repository);
            for (String groupName : sampleSet.getGroups(resource)) {
                AttributeGroupType groupType = new AttributeGroupType(groupName, "ignore");
                for (Sample sample : sampleSet.getSamplesForResourceAndGroup(resource, groupName)) {
                    SamplerCollectionAttributeType attribType = new SamplerCollectionAttributeType(groupType, sample.getMetric());
                    SamplerCollectionAttribute attrib = new SamplerCollectionAttribute(attribType, collectionResource, sample);
                    collectionResource.getGroup(groupType).addAttribute((CollectionAttribute)attrib);
                }
            }
            collectionSet.getCollectionResources().add(collectionResource);
        }
        collectionSet.setStatus(1);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    public RrdRepository getRrdRepository() {
        return this.m_repo;
    }

    public void setRrdRepository(RrdRepository repo) {
        this.m_repo = repo;
    }

    public Results find(SampleProcessorBuilder builder, Timestamp start, Timestamp end, Resource resource, Metric ... metrics) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".find() is not supported");
    }
}

