/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.internal;

import java.util.EventListener;
import java.util.Hashtable;
import javax.servlet.Filter;
import org.opennms.container.web.bridge.internal.DispatcherFilter;
import org.opennms.container.web.felix.base.internal.AbstractActivator;
import org.opennms.container.web.felix.base.internal.EventDispatcher;
import org.opennms.container.web.felix.base.internal.HttpServiceController;
import org.opennms.container.web.felix.base.internal.logger.SystemLogger;

public final class BridgeActivator
extends AbstractActivator {
    private DispatcherFilter dispatcher;
    private EventDispatcher eventDispatcher;
    private HttpServiceController controller;

    protected DispatcherFilter getDispatcherFilter() {
        return this.dispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected HttpServiceController getHttpServiceController() {
        return this.controller;
    }

    @Override
    protected void doStart() throws Exception {
        this.controller = new HttpServiceController(this.getBundleContext());
        this.dispatcher = new DispatcherFilter(this.controller);
        this.eventDispatcher = new EventDispatcher(this.controller);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("http.felix.dispatcher", this.getDispatcherFilter().getClass().getName());
        props.put("service.description", "Dispatcher for bridged request handling");
        props.put("service.vendor", "The OpenNMS Group, Inc.");
        this.getBundleContext().registerService(Filter.class, (Object)this.getDispatcherFilter(), props);
        props = new Hashtable();
        props.put("http.felix.dispatcher", this.getEventDispatcher().getClass().getName());
        props.put("service.description", "Dispatcher for bridged HttpSession events");
        props.put("service.vendor", "The OpenNMS Group, Inc.");
        this.getBundleContext().registerService(EventListener.class, (Object)this.getEventDispatcher(), props);
        SystemLogger.info("Started bridged http service");
    }

    @Override
    protected void doStop() throws Exception {
        this.controller.unregister();
        this.dispatcher.destroy();
    }
}

