/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample.math;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.NanValue;
import org.opennms.netmgt.api.sample.Results;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.SampleProcessor;
import org.opennms.netmgt.api.sample.SampleValue;
import org.opennms.netmgt.api.sample.Timestamp;

public class RollUp
extends SampleProcessor {
    private final long m_heartBeat;
    private final long m_step;
    private final TimeUnit m_timeUnits;
    private boolean m_isInitialized = false;
    private Timestamp m_currStepFloor;
    private PrimaryDataPoint m_currPdp;
    private Results.Row m_currRow;
    private Results.Row m_prevRow;

    public RollUp(long heartBeat, long step, TimeUnit timeUnits) {
        this.m_heartBeat = heartBeat;
        this.m_step = step;
        this.m_timeUnits = timeUnits;
    }

    @Override
    public boolean hasNext() {
        return this.getProducer().hasNext();
    }

    @Override
    public Results.Row next() {
        Results.Row resultRow = null;
        while (this.consume()) {
            resultRow = this.m_currPdp.addSamples(this.m_currRow);
            if (resultRow == null) continue;
            this.m_currStepFloor = this.nextStep();
            this.m_currPdp = this.getNextPdp();
            break;
        }
        return resultRow != null ? resultRow : this.getNanSamples(this.nextStep());
    }

    private boolean consume() {
        if (!this.hasNext()) {
            return false;
        }
        if (!this.m_isInitialized) {
            return this.initialize();
        }
        if (!this.m_currRow.getTimestamp().greaterThan(this.nextStep())) {
            this.m_prevRow = this.m_currRow;
            this.m_currRow = (Results.Row)this.getProducer().next();
        }
        return true;
    }

    private boolean initialize() {
        if (!this.m_isInitialized) {
            try {
                this.m_prevRow = (Results.Row)this.getProducer().next();
                this.m_currRow = (Results.Row)this.getProducer().next();
            }
            catch (NoSuchElementException err) {
                return false;
            }
            this.m_currStepFloor = this.m_prevRow.getTimestamp().atStepBoundaryStart(this.m_step, this.m_timeUnits);
            this.m_currPdp = new PrimaryDataPoint(this.m_currStepFloor, this.nextStep(), this.m_prevRow);
            this.m_isInitialized = true;
        }
        return true;
    }

    private PrimaryDataPoint getNextPdp() {
        Results.Row first = this.m_currRow.getTimestamp().greaterThan(this.nextStep()) ? this.m_prevRow : this.m_currRow;
        return new PrimaryDataPoint(this.m_currStepFloor, this.nextStep(), first);
    }

    private Results.Row getNanSamples(Timestamp time) {
        Results.Row row = new Results.Row(this.getResource(), time);
        for (Metric m : this.getMetrics()) {
            row.addSample(new Sample(row.getResource(), m, row.getTimestamp(), new NanValue()));
        }
        return row;
    }

    private Timestamp nextStep() {
        return this.nextStep(this.m_currStepFloor);
    }

    private Timestamp nextStep(Timestamp time) {
        return time.plus(this.m_step, this.m_timeUnits);
    }

    public String toString() {
        return String.format("%s | %s(%d, %d, %s)", new Object[]{this.getProducer().toString(), this.getClass().getSimpleName(), this.m_heartBeat, this.m_step, this.m_timeUnits});
    }

    private final class PrimaryDataPoint {
        private final Timestamp m_finish;
        private final long m_heartBeatMs;
        private Results.Row m_prevAveraged;
        private int m_rowCount;
        private int m_unknownMs;

        private PrimaryDataPoint(Timestamp start, Timestamp finish, Results.Row first) {
            this.m_heartBeatMs = TimeUnit.MILLISECONDS.convert(RollUp.this.m_heartBeat, RollUp.this.m_timeUnits);
            this.m_rowCount = 0;
            this.m_unknownMs = 0;
            this.m_finish = finish;
            this.m_prevAveraged = first;
            ++this.m_rowCount;
        }

        private Results.Row addSamples(Results.Row row) {
            ++this.m_rowCount;
            long lastInterval = row.getTimestamp().asMillis() - this.m_prevAveraged.getTimestamp().asMillis();
            if (lastInterval > this.m_heartBeatMs) {
                this.m_unknownMs = (int)((long)this.m_unknownMs + lastInterval);
            }
            Results.Row currAveraged = this.getCumulativeAverageSamples(row);
            if (row.getTimestamp().greaterThan(this.m_finish) || row.getTimestamp().equals(this.m_finish)) {
                Results.Row result = new Results.Row(RollUp.this.getResource(), this.m_finish);
                if ((long)this.m_unknownMs <= TimeUnit.MILLISECONDS.convert(RollUp.this.m_step, RollUp.this.m_timeUnits) / 2L) {
                    this.addInterpolatedSamples(result, this.m_prevAveraged, currAveraged);
                } else {
                    result = RollUp.this.getNanSamples(this.m_finish);
                }
                return result;
            }
            this.m_prevAveraged = currAveraged;
            return null;
        }

        private Results.Row getCumulativeAverageSamples(Results.Row current) {
            Results.Row row = new Results.Row(RollUp.this.getResource(), current.getTimestamp());
            for (Metric m : RollUp.this.getMetrics()) {
                row.addSample(this.getCumulativeAverageSample(this.m_prevAveraged.getSample(m), current.getSample(m)));
            }
            return row;
        }

        private Sample getCumulativeAverageSample(Sample previous, Sample current) {
            SampleValue<?> newAvg = previous.getValue().multiply(this.m_rowCount - 1).add(current.getValue()).divide(this.m_rowCount);
            return new Sample(current.getResource(), current.getMetric(), current.getTimestamp(), newAvg);
        }

        private void addInterpolatedSamples(Results.Row row, Results.Row row0, Results.Row row1) {
            for (Metric m : RollUp.this.getMetrics()) {
                Sample y0 = row0.getSample(m);
                Sample y1 = row1.getSample(m);
                SampleValue value = null;
                value = y0 != null && y1 != null ? this.interpolate(row.getTimestamp(), row0.getTimestamp(), row1.getTimestamp(), y0, y1) : new NanValue();
                row.addSample(new Sample(RollUp.this.getResource(), m, row.getTimestamp(), value));
            }
        }

        private SampleValue<?> interpolate(Timestamp x, Timestamp x0, Timestamp x1, Sample y0, Sample y1) {
            return this.interpolate(x.asMillis(), x0.asMillis(), x1.asMillis(), y0.getValue(), y1.getValue());
        }

        private SampleValue<?> interpolate(long x, long x0, long x1, SampleValue<?> y0, SampleValue<?> y1) {
            return y1.subtract(y0).multiply(x - x0).divide(x1 - x0).add(y0);
        }
    }
}

