/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.builder.xml.TimeUnitAdapter;

@XmlRootElement(name="timestamp")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Timestamp
implements Comparable<Timestamp>,
Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="time")
    private final long m_time;
    @XmlAttribute(name="unit")
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private final TimeUnit m_unit;

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public Timestamp() {
        this.m_time = new Date().getTime();
        this.m_unit = TimeUnit.MILLISECONDS;
    }

    public Timestamp(long time, TimeUnit unit) {
        this.m_time = time;
        this.m_unit = unit;
    }

    public Timestamp(Date date) {
        this.m_time = date.getTime();
        this.m_unit = TimeUnit.MILLISECONDS;
    }

    public long convert(TimeUnit newUnit) {
        return newUnit.convert(this.m_time, this.m_unit);
    }

    public long asSeconds() {
        return this.convert(TimeUnit.SECONDS);
    }

    public long asMillis() {
        return this.convert(TimeUnit.MILLISECONDS);
    }

    public Date asDate() {
        return new Date(this.convert(TimeUnit.MILLISECONDS));
    }

    public boolean leftOf(Timestamp o) {
        return this.lessThan(o);
    }

    public boolean rightOf(Timestamp o) {
        return this.greaterThan(o);
    }

    public boolean lessThan(Timestamp o) {
        return this.compareTo(o) < 0;
    }

    public boolean greaterThan(Timestamp o) {
        return this.compareTo(o) > 0;
    }

    @Override
    public int compareTo(Timestamp o) {
        long otherMillis;
        long millis = this.convert(TimeUnit.MILLISECONDS);
        return millis < (otherMillis = o.convert(TimeUnit.MILLISECONDS)) ? -1 : (millis > otherMillis ? 1 : 0);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        return this.asMillis() == ((Timestamp)other).asMillis();
    }

    public int hashCode() {
        return Long.valueOf(this.asMillis()).hashCode();
    }

    public String toString() {
        return String.format("%1$tY-%1$tb-%1$td %1$tH:%1$tM:%1$tS.%1$tL", this.asMillis());
    }

    public Timestamp roundToStep(long stepSize, TimeUnit stepUnits) {
        long ts = this.convert(stepUnits);
        long skew = ts % stepSize;
        long res = skew > stepSize / 2L ? ts + (stepSize - skew) : ts - skew;
        return new Timestamp(res, stepUnits);
    }

    public Timestamp atStepBoundaryStart(long stepSize, TimeUnit stepUnits) {
        long ts = this.convert(stepUnits);
        return new Timestamp(ts / stepSize * stepSize, stepUnits);
    }

    public Timestamp atStepBoundaryEnd(long stepSize, TimeUnit stepUnits) {
        long ts = this.convert(stepUnits);
        return new Timestamp((ts / stepSize + 1L) * stepSize, stepUnits);
    }

    public Timestamp plus(Timestamp time) {
        return this.plus(time.asMillis(), TimeUnit.MILLISECONDS);
    }

    public Timestamp minus(Timestamp time) {
        return this.minus((int)time.asMillis(), TimeUnit.MILLISECONDS);
    }

    public Timestamp plus(long time, TimeUnit unit) {
        long duration = this.m_unit.convert(time, unit);
        return new Timestamp(this.m_time + duration, this.m_unit);
    }

    public Timestamp minus(int time, TimeUnit unit) {
        long duration = this.m_unit.convert(time, unit);
        return new Timestamp(this.m_time - duration, this.m_unit);
    }
}

