/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opennms.netmgt.api.sample.Metric;
import org.opennms.netmgt.api.sample.Resource;
import org.opennms.netmgt.api.sample.Sample;
import org.opennms.netmgt.api.sample.Timestamp;

public class Results
implements Iterable<Row> {
    private Resource m_resource;
    private Metric[] m_metrics;
    private Map<Metric, SortedSet<Sample>> m_columns = new LinkedHashMap<Metric, SortedSet<Sample>>();
    private Map<Timestamp, Row> m_rows = new TreeMap<Timestamp, Row>();

    public Results(Resource resource, Metric ... metrics) {
        this.m_resource = resource;
        this.m_metrics = metrics;
        for (Metric m : metrics) {
            this.m_columns.put(m, new TreeSet());
        }
    }

    public Resource getResource() {
        return this.m_resource;
    }

    public List<Metric> getMetrics() {
        return Arrays.asList(this.m_metrics);
    }

    public void addSample(Sample m) {
        SortedSet<Sample> column = this.m_columns.get(m.getMetric());
        column.add(m);
        Row r = this.m_rows.get(m.getTimestamp());
        if (r == null) {
            r = new Row(this.m_resource, m.getTimestamp());
            this.m_rows.put(m.getTimestamp(), r);
        }
        r.addSample(m);
    }

    public SortedSet<Sample> getColumn(Metric m) {
        return this.m_columns.get(m);
    }

    public Collection<Row> getRows() {
        return this.m_rows.values();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Row row : this.m_rows.values()) {
            buf.append(row).append('\n');
        }
        return buf.toString();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.getRows().iterator();
    }

    public static class Row
    implements Iterable<Sample> {
        private final Resource m_resource;
        private final Timestamp m_timestamp;
        private final Map<Metric, Sample> m_cells = new HashMap<Metric, Sample>();

        public Row(Resource resource, Timestamp timestamp) {
            this.m_resource = resource;
            this.m_timestamp = timestamp;
        }

        public void addSample(Sample m) {
            this.m_cells.put(m.getMetric(), m);
        }

        public Sample getSample(Metric metric) {
            return this.m_cells.get(metric);
        }

        public boolean containsSample(Metric metric) {
            return this.m_cells.containsKey(metric);
        }

        public Collection<Sample> getSamples() {
            return this.m_cells.values();
        }

        public Timestamp getTimestamp() {
            return this.m_timestamp;
        }

        @Override
        public Iterator<Sample> iterator() {
            return this.m_cells.values().iterator();
        }

        public Resource getResource() {
            return this.m_resource;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.m_timestamp).append(" :");
            for (Sample sample : this.m_cells.values()) {
                buf.append(' ').append(sample.getMetric().getName()).append(":").append(sample.getValue());
            }
            return buf.toString();
        }
    }
}

