/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.api.sample;

import java.math.BigInteger;
import org.opennms.netmgt.api.sample.MetricType;
import org.opennms.netmgt.api.sample.SampleValue;

public class CounterValue
extends SampleValue<BigInteger> {
    private static final long serialVersionUID = 2L;
    private static final BigInteger MAX32 = BigInteger.valueOf(2L).pow(32).subtract(BigInteger.ONE);
    private static final BigInteger MAX64 = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);

    public CounterValue() {
        this(null);
    }

    public CounterValue(long value) {
        this(BigInteger.valueOf(value));
    }

    public CounterValue(BigInteger value) {
        super(value);
    }

    public CounterValue delta(Number other) {
        BigInteger diff = ((BigInteger)this.getValue()).subtract(this.getBigInt(other));
        if (diff.compareTo(BigInteger.ZERO) < 0) {
            BigInteger diff32 = diff.add(MAX32).add(BigInteger.ONE);
            if (diff32.compareTo(BigInteger.ZERO) < 0) {
                return new CounterValue(diff.add(MAX64).add(BigInteger.ONE));
            }
            return new CounterValue(diff32);
        }
        return new CounterValue(diff);
    }

    public CounterValue add(Number other) {
        return new CounterValue(((BigInteger)this.getValue()).add(this.getBigInt(other)));
    }

    public CounterValue subtract(Number other) {
        return new CounterValue(((BigInteger)this.getValue()).subtract(this.getBigInt(other)));
    }

    public CounterValue multiply(Number other) {
        return new CounterValue(((BigInteger)this.getValue()).multiply(this.getBigInt(other)));
    }

    public CounterValue divide(Number object) {
        return new CounterValue(((BigInteger)this.getValue()).divide(this.getBigInt(object)));
    }

    @Override
    public int intValue() {
        return ((BigInteger)this.getValue()).intValue();
    }

    @Override
    public long longValue() {
        return ((BigInteger)this.getValue()).longValue();
    }

    @Override
    public float floatValue() {
        return ((BigInteger)this.getValue()).floatValue();
    }

    @Override
    public double doubleValue() {
        return ((BigInteger)this.getValue()).doubleValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return (BigInteger)this.getValue();
    }

    @Override
    public MetricType getType() {
        return MetricType.COUNTER;
    }

    @Override
    public int compareTo(Number o) {
        return ((BigInteger)this.getValue()).compareTo(this.getBigInt(o));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CounterValue) {
            return ((BigInteger)this.getValue()).equals(((CounterValue)o).getValue());
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)this.getValue()).equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((BigInteger)this.getValue()).hashCode();
    }

    private BigInteger getBigInt(Number num) {
        if (num instanceof CounterValue) {
            return (BigInteger)((CounterValue)num).getValue();
        }
        return BigInteger.valueOf(num.longValue());
    }
}

