/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.dominion.controller.internal;

import java.io.Reader;
import java.io.StringReader;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.opennms.minion.api.MinionStatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializationListener
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(InitializationListener.class);

    public InitializationListener() {
        LOG.info("Starting InitializationListener.");
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            LOG.info("Initialization received: {}", (Object)message);
            TextMessage textMessage = (TextMessage)message;
            try (StringReader reader = null;){
                String text = textMessage.getText();
                reader = new StringReader(text);
                Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{MinionStatusMessage.class}).createUnmarshaller();
                MinionStatusMessage m = (MinionStatusMessage)unmarshaller.unmarshal((Reader)reader);
                LOG.info("Successfully unmarshalled: {}", (Object)m);
            }
        } else {
            LOG.warn("Unhandled message: {}", (Object)message);
        }
    }
}

