/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.driver.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Driver;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.driver.impl.ConnectorImpl;
import org.apache.qpid.proton.driver.impl.ListenerImpl;

public class DriverImpl
implements Driver {
    private Selector _selector;
    private Collection<Listener> _listeners = new LinkedList<Listener>();
    private Collection<Connector> _connectors = new LinkedList<Connector>();
    private Logger _logger = Logger.getLogger("proton.driver");
    private Object _wakeupLock = new Object();
    private boolean _woken = false;
    private Queue<ConnectorImpl> _selectedConnectors = new ArrayDeque<ConnectorImpl>();
    private Queue<ListenerImpl> _selectedListeners = new ArrayDeque<ListenerImpl>();

    DriverImpl() throws IOException {
        this._selector = Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeup() {
        Object object = this._wakeupLock;
        synchronized (object) {
            this._woken = true;
        }
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWait(long timeout) {
        try {
            boolean woken;
            Object object = this._wakeupLock;
            synchronized (object) {
                woken = this._woken;
            }
            if (woken || timeout == 0L) {
                this._selector.selectNow();
            } else if (timeout < 0L) {
                this._selector.select(0L);
            } else {
                this._selector.select(timeout);
            }
            object = this._wakeupLock;
            synchronized (object) {
                woken = woken || this._woken;
                this._woken = false;
            }
            for (SelectionKey key : this._selector.selectedKeys()) {
                if (key.isAcceptable()) {
                    ListenerImpl l = (ListenerImpl)key.attachment();
                    l.selected();
                    continue;
                }
                ConnectorImpl c = (ConnectorImpl)key.attachment();
                c.selected();
            }
            this._selector.selectedKeys().clear();
            return woken;
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when waiting for IO Event", e);
            throw new RuntimeException(e);
        }
    }

    void selectListener(ListenerImpl l) {
        this._selectedListeners.add(l);
    }

    @Override
    public Listener listener() {
        ListenerImpl listener = this._selectedListeners.poll();
        if (listener != null) {
            listener.unselected();
        }
        return listener;
    }

    void selectConnector(ConnectorImpl c) {
        this._selectedConnectors.add(c);
    }

    @Override
    public Connector connector() {
        ConnectorImpl connector = this._selectedConnectors.poll();
        if (connector != null) {
            connector.unselected();
        }
        return connector;
    }

    @Override
    public void destroy() {
        try {
            this._selector.close();
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception when closing selector", e);
            throw new RuntimeException(e);
        }
        this._listeners.clear();
        this._connectors.clear();
    }

    @Override
    public <C> Listener<C> createListener(String host, int port, C context) {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.bind(new InetSocketAddress(host, port));
            Listener<C> listener = this.createListener(serverSocketChannel, context);
            this._logger.fine("Created listener on " + host + ":" + port + ": " + context);
            return listener;
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <C> Listener<C> createListener(ServerSocketChannel c, C context) {
        ListenerImpl<C> l = new ListenerImpl<C>(this, c, context);
        SelectionKey key = this.registerInterest(c, 16);
        key.attach(l);
        this._listeners.add(l);
        return l;
    }

    @Override
    public <C> Connector<C> createConnector(String host, int port, C context) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(host, port));
            return this.createConnector(channel, context);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C> Connector<C> createConnector(SelectableChannel c, C context) {
        SelectionKey key = this.registerInterest(c, 5);
        ConnectorImpl<C> co = new ConnectorImpl<C>(this, null, (SocketChannel)c, context, key);
        key.attach(co);
        this._connectors.add(co);
        return co;
    }

    public <C> void removeConnector(Connector<C> c) {
        this._connectors.remove(c);
    }

    @Override
    public Iterable<Listener> listeners() {
        return this._listeners;
    }

    @Override
    public Iterable<Connector> connectors() {
        return this._connectors;
    }

    protected <C> Connector<C> createServerConnector(SelectableChannel c, C context, Listener<C> l) {
        SelectionKey key = this.registerInterest(c, 5);
        ConnectorImpl<C> co = new ConnectorImpl<C>(this, l, (SocketChannel)c, context, key);
        key.attach(co);
        this._connectors.add(co);
        return co;
    }

    private <C> SelectionKey registerInterest(SelectableChannel c, int opKeys) {
        try {
            return c.register(this._selector, opKeys);
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

