/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.session.ReservedSessionMessagesManager;
import org.apache.sshd.common.session.SessionListenerManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public interface Session
extends KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
ChannelListenerManager,
PortForwardingEventListenerManager,
FactoryManagerHolder,
PropertyResolver,
AttributeStore,
Closeable,
MutableUserHolder {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String FALLBACK_SSH_VERSION_PREFIX = "SSH-1.99-";
    public static final int MAX_VERSION_LINE_LENGTH = 256;

    public String getClientVersion();

    public String getServerVersion();

    public String getNegotiatedKexParameter(KexProposalOption var1);

    public CipherInformation getCipherInformation(boolean var1);

    public CompressionInformation getCompressionInformation(boolean var1);

    public MacInformation getMacInformation(boolean var1);

    public Buffer createBuffer(byte var1);

    public Buffer createBuffer(byte var1, int var2);

    public Buffer prepareBuffer(byte var1, Buffer var2);

    public IoWriteFuture sendDebugMessage(boolean var1, Object var2, String var3) throws IOException;

    public IoWriteFuture sendIgnoreMessage(byte ... var1) throws IOException;

    public IoWriteFuture writePacket(Buffer var1) throws IOException;

    public IoWriteFuture writePacket(Buffer var1, long var2, TimeUnit var4) throws IOException;

    public Buffer request(String var1, Buffer var2, long var3, TimeUnit var5) throws IOException;

    public void exceptionCaught(Throwable var1);

    public KeyExchangeFuture reExchangeKeys() throws IOException;

    public <T extends Service> T getService(Class<T> var1);

    public IoSession getIoSession();

    public void resetIdleTimeout();

    public TimeoutStatus getTimeoutStatus();

    public long getAuthTimeout();

    public long getIdleTimeout();

    public boolean isAuthenticated();

    public void setAuthenticated() throws IOException;

    public byte[] getSessionId();

    public KeyExchange getKex();

    public void disconnect(int var1, String var2) throws IOException;

    public void startService(String var1) throws Exception;

    public static boolean isValidVersionPrefix(String version) {
        return GenericUtils.isNotEmpty(version) && (version.startsWith(DEFAULT_SSH_VERSION_PREFIX) || version.startsWith(FALLBACK_SSH_VERSION_PREFIX));
    }

    public static enum TimeoutStatus {
        NoTimeout,
        AuthTimeout,
        IdleTimeout;

    }
}

