/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleWatcher;
import org.apache.karaf.bundle.core.internal.MavenConfigService;
import org.apache.karaf.util.bundles.BundleUtils;
import org.apache.karaf.util.maven.Parser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleWatcherImpl
implements Runnable,
BundleListener,
BundleWatcher {
    private final Logger logger = LoggerFactory.getLogger(BundleWatcherImpl.class);
    private BundleContext bundleContext;
    private final BundleService bundleService;
    private final MavenConfigService localRepoDetector;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long interval = 1000L;
    private List<String> watchURLs = new CopyOnWriteArrayList<String>();
    private AtomicInteger counter = new AtomicInteger(0);

    public BundleWatcherImpl(BundleContext bundleContext, MavenConfigService mavenConfigService, BundleService bundleService) {
        this.bundleContext = bundleContext;
        this.localRepoDetector = mavenConfigService;
        this.bundleService = bundleService;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1 || event.getType() == 16) {
            this.counter.incrementAndGet();
        }
    }

    @Override
    public void run() {
        this.logger.debug("Bundle watcher thread started");
        int oldCounter = -1;
        HashSet<Bundle> watchedBundles = new HashSet<Bundle>();
        while (this.running.get() && this.watchURLs.size() > 0) {
            if (oldCounter != this.counter.get()) {
                oldCounter = this.counter.get();
                watchedBundles.clear();
                for (String bundleURL : this.watchURLs) {
                    bundleURL = bundleURL.replaceAll("\\*", ".*");
                    for (Bundle bundle : this.bundleService.selectBundles(Collections.singletonList(bundleURL), false)) {
                        if (!this.isMavenSnapshotUrl(this.getLocation(bundle))) continue;
                        watchedBundles.add(bundle);
                    }
                }
            }
            if (watchedBundles.size() > 0) {
                Bundle bundle;
                FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
                File localRepository = this.localRepoDetector.getLocalRepository();
                ArrayList<Bundle> updated = new ArrayList<Bundle>();
                bundle = watchedBundles.iterator();
                while (bundle.hasNext()) {
                    Bundle bundle2 = (Bundle)bundle.next();
                    try {
                        this.updateBundleIfNecessary(localRepository, updated, bundle2);
                    }
                    catch (IOException ex) {
                        this.logger.error("Error watching bundle.", (Throwable)ex);
                    }
                    catch (BundleException ex) {
                        this.logger.error("Error updating bundle.", (Throwable)ex);
                    }
                }
                if (!updated.isEmpty()) {
                    try {
                        final CountDownLatch latch = new CountDownLatch(1);
                        wiring.refreshBundles(updated, new FrameworkListener[]{new FrameworkListener(){

                            public void frameworkEvent(FrameworkEvent event) {
                                latch.countDown();
                            }
                        }});
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        this.running.set(false);
                    }
                    for (Bundle bundle2 : updated) {
                        try {
                            if (bundle2.getHeaders().get("Fragment-Host") != null) {
                                this.logger.info("[Watch] Bundle {} is a fragment, so it's not started", (Object)bundle2.getSymbolicName());
                                continue;
                            }
                            bundle2.start(1);
                        }
                        catch (BundleException ex) {
                            this.logger.warn("[Watch] Error starting bundle", (Throwable)ex);
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ex) {
                this.running.set(false);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bundle watcher thread stopped");
        }
    }

    private String getLocation(Bundle bundle) {
        String location = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
        return location != null ? location : bundle.getLocation();
    }

    private boolean isMavenSnapshotUrl(String url) {
        return url.startsWith("mvn:") && url.contains("SNAPSHOT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBundleIfNecessary(File localRepository, List<Bundle> updated, Bundle bundle) throws BundleException, IOException {
        File location = this.getBundleExternalLocation(localRepository, bundle);
        if (location != null && location.exists() && location.lastModified() > bundle.getLastModified()) {
            try (FileInputStream is = new FileInputStream(location);){
                this.logger.info("[Watch] Updating watched bundle: {} ({})", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
                if (bundle.getHeaders().get("Fragment-Host") != null) {
                    this.logger.info("[Watch] Bundle {} is a fragment, so it's not stopped", (Object)bundle.getSymbolicName());
                } else {
                    bundle.stop(1);
                }
                String updateLocation = this.getLocation(bundle);
                if (!updateLocation.equals(bundle.getLocation())) {
                    File file = BundleUtils.fixBundleWithUpdateLocation(is, updateLocation);
                    try (FileInputStream fis = new FileInputStream(file);){
                        bundle.update((InputStream)fis);
                    }
                    file.delete();
                } else {
                    bundle.update((InputStream)is);
                }
                updated.add(bundle);
            }
        }
    }

    @Override
    public void add(String url) {
        boolean shouldStart;
        boolean bl = shouldStart = this.running.get() && this.watchURLs.size() == 0;
        if (!this.watchURLs.contains(url)) {
            this.watchURLs.add(url);
            this.counter.incrementAndGet();
        }
        if (shouldStart) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public void remove(String url) {
        this.watchURLs.remove(url);
        this.counter.incrementAndGet();
    }

    private File getBundleExternalLocation(File localRepository, Bundle bundle) {
        try {
            Parser p = new Parser(this.getLocation(bundle).substring(4));
            return new File(localRepository.getPath() + File.separator + p.getArtifactPath());
        }
        catch (MalformedURLException e) {
            this.logger.error("Could not parse artifact path for bundle" + bundle.getSymbolicName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void start() {
        this.bundleContext.addBundleListener((BundleListener)this);
        if (this.running.compareAndSet(false, true) && this.watchURLs.size() > 0) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public void stop() {
        this.running.set(false);
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    @Override
    public List<String> getWatchURLs() {
        return this.watchURLs;
    }

    @Override
    public void setWatchURLs(List<String> watchURLs) {
        this.watchURLs = watchURLs;
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public List<Bundle> getBundlesByURL(String urlFilter) {
        urlFilter = urlFilter.replaceAll("\\*", ".*");
        return this.bundleService.selectBundles(Collections.singletonList(urlFilter), false);
    }
}

