/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;

public class SshAgentPublicKeyIterator
extends AbstractKeyPairIterator<KeyAgentIdentity> {
    private final SshAgent agent;
    private final Iterator<Pair<PublicKey, String>> keys;

    public SshAgentPublicKeyIterator(ClientSession session, SshAgent agent) throws IOException {
        super(session);
        this.agent = Objects.requireNonNull(agent, "No agent");
        this.keys = GenericUtils.iteratorOf(agent.getIdentities());
    }

    @Override
    public boolean hasNext() {
        return this.keys != null && this.keys.hasNext();
    }

    @Override
    public KeyAgentIdentity next() {
        Pair<PublicKey, String> kp = this.keys.next();
        return new KeyAgentIdentity(this.agent, kp.getFirst(), kp.getSecond());
    }
}

