/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.aspectj.TypePatternClassFilter;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.DelegatePerTargetObjectIntroductionInterceptor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclareParentsAdvisor
implements IntroductionAdvisor {
    private final Class<?> introducedInterface;
    private final ClassFilter typePatternClassFilter;
    private final Advice advice;

    public DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, Class<?> defaultImpl) {
        this(interfaceType, typePattern, defaultImpl, new DelegatePerTargetObjectIntroductionInterceptor(defaultImpl, interfaceType));
    }

    public DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, Object delegateRef) {
        this(interfaceType, typePattern, delegateRef.getClass(), new DelegatingIntroductionInterceptor(delegateRef));
    }

    private DeclareParentsAdvisor(Class<?> interfaceType, String typePattern, Class<?> implementationClass, Advice advice) {
        this.introducedInterface = interfaceType;
        TypePatternClassFilter typePatternFilter = new TypePatternClassFilter(typePattern);
        ClassFilter exclusion = new ClassFilter(){

            @Override
            public boolean matches(Class<?> clazz) {
                return !DeclareParentsAdvisor.this.introducedInterface.isAssignableFrom(clazz);
            }
        };
        this.typePatternClassFilter = ClassFilters.intersection(typePatternFilter, exclusion);
        this.advice = advice;
    }

    @Override
    public ClassFilter getClassFilter() {
        return this.typePatternClassFilter;
    }

    @Override
    public void validateInterfaces() throws IllegalArgumentException {
    }

    @Override
    public boolean isPerInstance() {
        return true;
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public Class<?>[] getInterfaces() {
        return new Class[]{this.introducedInterface};
    }
}

