/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class BouncyCastleKeyPairResourceParser
extends AbstractKeyPairResourceParser {
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Arrays.asList("BEGIN RSA PRIVATE KEY", "BEGIN DSA PRIVATE KEY", "BEGIN EC PRIVATE KEY"));
    public static final List<String> ENDERS = Collections.unmodifiableList(Arrays.asList("END RSA PRIVATE KEY", "END DSA PRIVATE KEY", "END EC PRIVATE KEY"));
    public static final BouncyCastleKeyPairResourceParser INSTANCE = new BouncyCastleKeyPairResourceParser();

    public BouncyCastleKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        StringBuilder writer = new StringBuilder(beginMarker.length() + endMarker.length() + lines.size() * 80);
        writer.append(beginMarker).append(IoUtils.EOL);
        lines.forEach(l -> writer.append((String)l).append(IoUtils.EOL));
        writer.append(endMarker).append(IoUtils.EOL);
        String data = writer.toString();
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(dataBytes);){
            Collection<KeyPair> collection = this.extractKeyPairs(resourceKey, beginMarker, endMarker, passwordProvider, bais);
            return collection;
        }
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        KeyPair kp = BouncyCastleKeyPairResourceParser.loadKeyPair(resourceKey, stream, passwordProvider);
        return kp == null ? Collections.emptyList() : Collections.singletonList(kp);
    }

    public static KeyPair loadKeyPair(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        try (PEMParser r = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            KeyPair keyPair;
            Object o = r.readObject();
            SecurityProviderRegistrar registrar = SecurityUtils.getRegisteredProvider("BC");
            if (registrar == null) {
                throw new NoSuchProviderException("BC registrar not available");
            }
            JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
            if (registrar.isNamedProviderUsed()) {
                pemConverter.setProvider(registrar.getName());
            } else {
                pemConverter.setProvider(registrar.getSecurityProvider());
            }
            if (o instanceof PEMEncryptedKeyPair) {
                ValidateUtils.checkNotNull(provider, "No password provider for resource=%s", (Object)resourceKey);
                String password = ValidateUtils.checkNotNullAndNotEmpty(provider.getPassword(resourceKey), "No password provided for resource=%s", (Object)resourceKey);
                JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(password.toCharArray());
                o = ((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor);
            }
            if (o instanceof PEMKeyPair) {
                keyPair = pemConverter.getKeyPair((PEMKeyPair)o);
                return keyPair;
            }
            if (o instanceof KeyPair) {
                keyPair = (KeyPair)o;
                return keyPair;
            }
            try {
                throw new IOException("Failed to read " + resourceKey + " - unknown result object: " + o);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

