/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentForwardedChannel;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer,
ExecutorServiceCarrier {
    public static final String AUTH_SOCKET_TIMEOUT = "ssh-agent-server-proxy-auth-socket-timeout";
    public static final int DEFAULT_AUTH_SOCKET_TIMEOUT = 10000000;
    private static final byte[] END_OF_STREAM_MESSAGE = new byte[]{"END_OF_STREAM".getBytes(StandardCharsets.UTF_8)[0]};
    private final ConnectionService service;
    private final String authSocket;
    private final long pool;
    private final long handle;
    private Future<?> piper;
    private final ExecutorService pipeService;
    private final boolean pipeCloseOnExit;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicBoolean innerFinished = new AtomicBoolean(false);

    public AgentServerProxy(ConnectionService service) throws IOException {
        this(service, null, false);
    }

    public AgentServerProxy(ConnectionService service, ExecutorService executor, boolean shutdownOnExit) throws IOException {
        this.service = service;
        try {
            String authSocket = AprLibrary.createLocalSocketAddress();
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            this.authSocket = authSocket;
            int result = Local.bind((long)this.handle, (long)0L);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            AprLibrary.secureLocalSocket(authSocket, this.handle);
            result = Local.listen((long)this.handle, (int)0);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            this.pipeService = executor == null ? ThreadUtils.newSingleThreadExecutor("sshd-AgentServerProxy-PIPE-" + authSocket) : executor;
            this.pipeCloseOnExit = executor != this.pipeService || shutdownOnExit;
            this.piper = this.pipeService.submit(() -> {
                try {
                    while (this.isOpen()) {
                        try {
                            long clientSock = Local.accept((long)this.handle);
                            if (!this.isOpen()) {
                                break;
                            }
                            Session session = this.service.getSession();
                            Socket.timeoutSet((long)clientSock, (long)session.getIntProperty(AUTH_SOCKET_TIMEOUT, 10000000));
                            String channelType = session.getStringProperty("ssh-agent-server-channel-proxy-type", "auth-agent@openssh.com");
                            AgentForwardedChannel channel = new AgentForwardedChannel(clientSock, channelType);
                            this.service.registerChannel(channel);
                            channel.open().verify(session.getLongProperty("ssh-agent-server-channel-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT));
                        }
                        catch (Exception e) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("run(open={}) {} while authentication forwarding: {}", new Object[]{this.isOpen(), e.getClass().getSimpleName(), e.getMessage()});
                            }
                            if (!this.log.isTraceEnabled()) continue;
                            this.log.trace("run(open=" + this.isOpen() + ") authentication forwarding failure details", (Throwable)e);
                        }
                    }
                }
                finally {
                    this.innerFinished.set(true);
                }
            });
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.pipeService;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.pipeCloseOnExit;
    }

    @Override
    public String getId() {
        return this.authSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        block19: {
            if (!this.open.getAndSet(false)) {
                return;
            }
            boolean isDebug = this.log.isDebugEnabled();
            if (this.handle != 0L) {
                int closeCode;
                block18: {
                    if (!this.innerFinished.get()) {
                        try {
                            int sendResult;
                            long tmpPool = Pool.create((long)AprLibrary.getInstance().getRootPool());
                            long tmpSocket = Local.create((String)this.authSocket, (long)tmpPool);
                            long connectResult = Local.connect((long)tmpSocket, (long)0L);
                            if (connectResult != 0L && isDebug) {
                                this.log.debug("Unable to connect to socket PIPE {}. APR errcode {}", (Object)this.authSocket, (Object)connectResult);
                            }
                            if ((sendResult = Socket.send((long)tmpSocket, (byte[])END_OF_STREAM_MESSAGE, (int)0, (int)1)) != 1 && isDebug) {
                                this.log.debug("Unable to send signal the EOS for {}. APR retcode {} != 1", (Object)this.authSocket, (Object)sendResult);
                            }
                        }
                        catch (Exception e) {
                            if (!isDebug) break block18;
                            this.log.debug("Exception connecting to the PIPE socket: " + this.authSocket, (Throwable)e);
                        }
                    }
                }
                if ((closeCode = Socket.close((long)this.handle)) != 0) {
                    this.log.warn("Exceptions closing the PIPE: {}. APR error code: {} ", (Object)this.authSocket, (Object)closeCode);
                }
            }
            try {
                File socketFile;
                if (this.authSocket != null && (socketFile = new File(this.authSocket)).exists()) {
                    this.deleteFile(socketFile, "Deleted PIPE socket {}");
                    if (OsUtils.isUNIX()) {
                        this.deleteFile(socketFile.getParentFile(), "Deleted parent PIPE socket {}");
                    }
                }
            }
            catch (Exception e) {
                if (!isDebug) break block19;
                this.log.debug("Exception deleting the PIPE socket: " + this.authSocket, (Throwable)e);
            }
        }
        try {
            if (this.piper != null && !this.piper.isDone()) {
                this.piper.cancel(true);
            }
        }
        finally {
            this.piper = null;
        }
        ExecutorService executor = this.getExecutorService();
        if (executor != null && this.isShutdownOnExit() && !executor.isShutdown()) {
            List<Runnable> runners = executor.shutdownNow();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Shut down runners count=" + GenericUtils.size(runners));
            }
        }
    }

    private void deleteFile(File file, String msg) {
        if (file.delete() && this.log.isDebugEnabled()) {
            this.log.debug(msg, (Object)file);
        }
    }

    static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

