/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.karaf.jaas.modules.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEncryption
implements Encryption {
    private static final Logger log = LoggerFactory.getLogger(BasicEncryption.class);
    private String algorithm;
    private String encoding;
    private MessageDigest md;

    public BasicEncryption(Map<String, String> params) {
        for (String key : params.keySet()) {
            if ("algorithm".equalsIgnoreCase(key)) {
                this.algorithm = params.get(key);
                continue;
            }
            if ("encoding".equalsIgnoreCase(key)) {
                this.encoding = params.get(key);
                continue;
            }
            throw new IllegalArgumentException("Unsupported encryption parameter: " + key);
        }
        if (this.algorithm == null) {
            throw new IllegalArgumentException("Digest algorithm must be specified");
        }
        try {
            this.md = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Initialization failed. Digest algorithm " + this.algorithm + " is not available.", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure login module: " + e.getMessage(), e);
        }
        if (this.encoding != null && this.encoding.length() > 0 && !"hexadecimal".equalsIgnoreCase(this.encoding) && !"base64".equalsIgnoreCase(this.encoding)) {
            log.error("Initialization failed. Digest encoding " + this.encoding + " is not supported.");
            throw new IllegalArgumentException("Unable to configure login module. Digest Encoding " + this.encoding + " not supported.");
        }
    }

    @Override
    public String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        byte[] data = this.md.digest(password.getBytes());
        if (this.encoding == null || this.encoding.length() == 0 || "hexadecimal".equalsIgnoreCase(this.encoding)) {
            return BasicEncryption.hexEncode(data);
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            return BasicEncryption.base64Encode(data);
        }
        throw new IllegalArgumentException("Unable to configure login module. Digest Encoding " + this.encoding + " not supported.");
    }

    @Override
    public boolean checkPassword(String provided, String real) {
        if (real == null && provided == null) {
            return true;
        }
        if (real == null || provided == null) {
            return false;
        }
        String encoded = this.encryptPassword(provided);
        if (this.encoding == null || this.encoding.length() == 0 || "hexadecimal".equalsIgnoreCase(this.encoding)) {
            return real.equalsIgnoreCase(encoded);
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            return real.equals(encoded);
        }
        return false;
    }

    public static String hexEncode(byte[] in) {
        return DatatypeConverter.printHexBinary((byte[])in);
    }

    public static String base64Encode(byte[] input) {
        return DatatypeConverter.printBase64Binary((byte[])input);
    }
}

