/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.threadio;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.apache.felix.gogo.runtime.threadio.Marker;
import org.apache.felix.gogo.runtime.threadio.ThreadInputStream;
import org.apache.felix.gogo.runtime.threadio.ThreadPrintStream;
import org.apache.felix.service.threadio.ThreadIO;

public class ThreadIOImpl
implements ThreadIO {
    private static final Logger log = Logger.getLogger(ThreadIOImpl.class.getName());
    final Marker defaultMarker = new Marker(System.in, System.out, System.err, null);
    final ThreadPrintStream err = new ThreadPrintStream(this, System.err, true);
    final ThreadPrintStream out = new ThreadPrintStream(this, System.out, false);
    final ThreadInputStream in = new ThreadInputStream(this, System.in);
    final ThreadLocal<Marker> current = new InheritableThreadLocal<Marker>(){

        @Override
        protected Marker initialValue() {
            return ThreadIOImpl.this.defaultMarker;
        }
    };

    public void start() {
        if (System.out instanceof ThreadPrintStream) {
            throw new IllegalStateException("Thread Print Stream already set");
        }
        System.setOut(this.out);
        System.setIn(this.in);
        System.setErr(this.err);
    }

    public void stop() {
        System.setErr(this.defaultMarker.err);
        System.setOut(this.defaultMarker.out);
        System.setIn(this.defaultMarker.in);
    }

    private void checkIO() {
        if (System.in != this.in) {
            log.fine("ThreadIO: eek! who's set System.in=" + System.in);
            System.setIn(this.in);
        }
        if (System.out != this.out) {
            log.fine("ThreadIO: eek! who's set System.out=" + System.out);
            System.setOut(this.out);
        }
        if (System.err != this.err) {
            log.fine("ThreadIO: eek! who's set System.err=" + System.err);
            System.setErr(this.err);
        }
    }

    Marker current() {
        Marker m = this.current.get();
        if (m.deactivated) {
            while (m.deactivated) {
                m = m.previous;
            }
            this.current.set(m);
        }
        return m;
    }

    @Override
    public void close() {
        this.checkIO();
        Marker top = this.current.get();
        if (top == null) {
            throw new IllegalStateException("No thread io active");
        }
        if (top != this.defaultMarker) {
            top.deactivate();
            this.current.set(top.previous);
        }
    }

    @Override
    public void setStreams(InputStream in, PrintStream out, PrintStream err) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.checkIO();
        Marker prev = this.current();
        if (in == this.in) {
            in = prev.getIn();
        }
        if (out == this.out) {
            out = prev.getOut();
        }
        if (err == this.err) {
            err = prev.getErr();
        }
        Marker marker = new Marker(in, out, err, prev);
        this.current.set(marker);
    }
}

