/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.management.ConnectorServerFactory;
import org.apache.karaf.management.JaasAuthenticator;
import org.apache.karaf.management.KarafMBeanServerGuard;
import org.apache.karaf.management.MBeanServerFactory;
import org.apache.karaf.management.RmiRegistryFactory;
import org.apache.karaf.management.internal.JMXSecurityMBeanImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=ConfigurationAdmin.class), @RequireService(value=KeystoreManager.class)}, provides={@ProvideService(value=MBeanServer.class)})
@Managed(value="org.apache.karaf.management")
public class Activator
extends BaseActivator
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ConnectorServerFactory connectorServerFactory;
    private RmiRegistryFactory rmiRegistryFactory;
    private MBeanServerFactory mbeanServerFactory;
    private ServiceTracker<KeystoreInstance, KeystoreInstance> keystoreInstanceServiceTracker;

    @Override
    protected void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        KeystoreManager keystoreManager = this.getTrackedService(KeystoreManager.class);
        if (configurationAdmin == null || keystoreManager == null) {
            return;
        }
        String rmiRegistryHost = this.getString("rmiRegistryHost", "");
        int rmiRegistryPort = this.getInt("rmiRegistryPort", 1099);
        String rmiServerHost = this.getString("rmiServerHost", "0.0.0.0");
        int rmiServerPort = this.getInt("rmiServerPort", 44444);
        String jmxRealm = this.getString("jmxRealm", "karaf");
        String serviceUrl = this.getString("serviceUrl", "service:jmx:rmi://" + rmiServerHost + ":" + rmiServerPort + "/jndi/rmi://" + rmiRegistryHost + ":" + rmiRegistryPort + "/karaf-" + System.getProperty("karaf.name"));
        boolean daemon = this.getBoolean("daemon", true);
        boolean threaded = this.getBoolean("threaded", true);
        ObjectName objectName = new ObjectName(this.getString("objectName", "connector:name=rmi"));
        long keyStoreAvailabilityTimeout = this.getLong("keyStoreAvailabilityTimeout", 5000L);
        String authenticatorType = this.getString("authenticatorType", "password");
        final boolean secured = this.getBoolean("secured", false);
        String secureAlgorithm = this.getString("secureAlgorithm", "default");
        String secureProtocol = this.getString("secureProtocol", "TLS");
        String keyStore = this.getString("keyStore", "karaf.ks");
        String keyAlias = this.getString("keyAlias", "karaf");
        String trustStore = this.getString("trustStore", "karaf.ts");
        boolean createRmiRegistry = this.getBoolean("createRmiRegistry", true);
        boolean locateRmiRegistry = this.getBoolean("locateRmiRegistry", true);
        boolean locateExistingMBeanServerIfPossible = this.getBoolean("locateExistingMBeanServerIfPossible", true);
        KarafMBeanServerGuard guard = new KarafMBeanServerGuard();
        guard.setConfigAdmin(configurationAdmin);
        this.rmiRegistryFactory = new RmiRegistryFactory();
        this.rmiRegistryFactory.setCreate(createRmiRegistry);
        this.rmiRegistryFactory.setLocate(locateRmiRegistry);
        this.rmiRegistryFactory.setHost(rmiRegistryHost);
        this.rmiRegistryFactory.setPort(rmiRegistryPort);
        this.rmiRegistryFactory.setBundleContext(this.bundleContext);
        this.rmiRegistryFactory.init();
        this.mbeanServerFactory = new MBeanServerFactory();
        this.mbeanServerFactory.setLocateExistingServerIfPossible(locateExistingMBeanServerIfPossible);
        this.mbeanServerFactory.init();
        MBeanServer mbeanServer = this.mbeanServerFactory.getServer();
        JaasAuthenticator jaasAuthenticator = new JaasAuthenticator();
        jaasAuthenticator.setRealm(jmxRealm);
        this.connectorServerFactory = new ConnectorServerFactory();
        this.connectorServerFactory.setServer(mbeanServer);
        this.connectorServerFactory.setServiceUrl(serviceUrl);
        this.connectorServerFactory.setGuard(guard);
        this.connectorServerFactory.setRmiServerHost(rmiServerHost);
        this.connectorServerFactory.setDaemon(daemon);
        this.connectorServerFactory.setThreaded(threaded);
        this.connectorServerFactory.setObjectName(objectName);
        HashMap<String, JaasAuthenticator> environment = new HashMap<String, JaasAuthenticator>();
        environment.put("jmx.remote.authenticator", jaasAuthenticator);
        try {
            this.connectorServerFactory.setEnvironment(environment);
            this.connectorServerFactory.setKeyStoreAvailabilityTimeout(keyStoreAvailabilityTimeout);
            this.connectorServerFactory.setAuthenticatorType(authenticatorType);
            this.connectorServerFactory.setSecured(secured);
            this.connectorServerFactory.setAlgorithm(secureAlgorithm);
            this.connectorServerFactory.setSecureProtocol(secureProtocol);
            this.connectorServerFactory.setKeyStore(keyStore);
            this.connectorServerFactory.setKeyAlias(keyAlias);
            this.connectorServerFactory.setTrustStore(trustStore);
            this.connectorServerFactory.setKeystoreManager(keystoreManager);
            this.connectorServerFactory.init();
        }
        catch (Exception e) {
            LOG.error("Can't init JMXConnectorServer: " + e.getMessage());
        }
        JMXSecurityMBeanImpl securityMBean = new JMXSecurityMBeanImpl();
        securityMBean.setMBeanServer(mbeanServer);
        securityMBean.setGuard(guard);
        this.registerMBean(securityMBean, "type=security,area=jmx");
        this.register(MBeanServer.class, mbeanServer);
        this.keystoreInstanceServiceTracker = new ServiceTracker(this.bundleContext, KeystoreInstance.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<KeystoreInstance, KeystoreInstance>(){

            public KeystoreInstance addingService(ServiceReference<KeystoreInstance> reference) {
                if (secured) {
                    try {
                        Activator.this.connectorServerFactory.init();
                    }
                    catch (Exception e) {
                        LOG.error("Can't re-init JMXConnectorServer with SSL enabled when register a keystore:" + e.getMessage());
                    }
                }
                return null;
            }

            public void modifiedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
            }

            public void removedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
                if (secured) {
                    try {
                        Activator.this.connectorServerFactory.init();
                    }
                    catch (Exception e) {
                        LOG.error("Can't re-init JMXConnectorServer with SSL enabled when unregister a keystore: " + e.getMessage());
                    }
                }
            }
        });
        this.keystoreInstanceServiceTracker.open();
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.connectorServerFactory != null) {
            try {
                this.connectorServerFactory.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Error destroying ConnectorServerFactory", (Throwable)e);
            }
            this.connectorServerFactory = null;
        }
        if (this.mbeanServerFactory != null) {
            try {
                this.mbeanServerFactory.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Error destroying MBeanServerFactory", (Throwable)e);
            }
            this.mbeanServerFactory = null;
        }
        if (this.rmiRegistryFactory != null) {
            try {
                this.rmiRegistryFactory.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Error destroying RMIRegistryFactory", (Throwable)e);
            }
            this.rmiRegistryFactory = null;
        }
        if (this.keystoreInstanceServiceTracker != null) {
            this.keystoreInstanceServiceTracker.close();
        }
    }
}

