/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.plugins.event.internal.EventCollector;
import org.apache.felix.webconsole.plugins.event.internal.EventInfo;
import org.apache.felix.webconsole.plugins.event.internal.PropertiesEditorSupport;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class PluginServlet
extends HttpServlet {
    private static final String ACTION_POST = "post";
    private static final String ACTION_SEND = "send";
    private static final String ACTION_CLEAR = "clear";
    private static final String PARAMETER_ACTION = "action";
    private final EventCollector collector = new EventCollector(null);
    private volatile boolean configAdminAvailable = false;
    private EventAdmin eventAdmin;
    private final String TEMPLATE = this.readTemplateFile(((Object)((Object)this)).getClass(), "/res/events.html");

    private final String readTemplateFile(Class clazz, String templateFile) {
        InputStream templateStream = ((Object)((Object)this)).getClass().getResourceAsStream(templateFile);
        if (templateStream != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            try {
                int len = 0;
                while ((len = templateStream.read(data)) > 0) {
                    baos.write(data, 0, len);
                }
                String string = baos.toString("UTF-8");
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("readTemplateFile: Error loading " + templateFile + ": " + e);
            }
            finally {
                try {
                    templateStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.log("readTemplateFile: File '" + templateFile + "' not found through class " + clazz);
        return "";
    }

    private static final Event newEvent(HttpServletRequest request) {
        String topic = request.getParameter("topic");
        return new Event(topic, (Dictionary)PropertiesEditorSupport.convertProperties(request));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter(PARAMETER_ACTION);
        if (ACTION_POST.equals(action)) {
            Event event = PluginServlet.newEvent(req);
            this.eventAdmin.postEvent(event);
        } else if (ACTION_SEND.equals(action)) {
            Event event = PluginServlet.newEvent(req);
            this.eventAdmin.sendEvent(event);
        } else if (ACTION_CLEAR.equals(action)) {
            this.collector.clear();
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter());
    }

    private void renderJSON(PrintWriter pw) throws IOException {
        List events = this.collector.getEvents();
        StringBuffer statusLine = new StringBuffer();
        statusLine.append(events.size());
        statusLine.append(" Event");
        if (events.size() != 1) {
            statusLine.append('s');
        }
        statusLine.append(" received");
        if (!events.isEmpty()) {
            statusLine.append(" since ");
            Date d = new Date();
            d.setTime(((EventInfo)events.get((int)0)).received);
            statusLine.append(d);
        }
        statusLine.append(". (Event admin: ");
        if (this.eventAdmin == null) {
            statusLine.append("un");
        }
        statusLine.append("available; Config admin: ");
        if (!this.configAdminAvailable) {
            statusLine.append("un");
        }
        statusLine.append("available)");
        long startTime = this.collector.getStartTime();
        long endTime = events.size() == 0 ? startTime : ((EventInfo)events.get((int)(events.size() - 1))).received;
        float scale = endTime == startTime ? 100.0f : 100.0f / (float)(endTime - startTime);
        JSONWriter writer = new JSONWriter(pw);
        writer.object();
        writer.key("status");
        writer.value(statusLine.toString());
        writer.key("data");
        writer.array();
        for (int index = events.size() - 1; index >= 0; --index) {
            this.eventJson(writer, (EventInfo)events.get(index), index, startTime, scale);
        }
        writer.endArray();
        writer.endObject();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw);
            return;
        }
        this.renderContent(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.print(this.TEMPLATE);
    }

    public URL getResource(String path) {
        if (path.startsWith("/events/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(7));
        }
        return null;
    }

    private void eventJson(JSONWriter jw, EventInfo info, int index, long start, float scale) throws IOException {
        long msec = info.received - start;
        int percent = Math.max((int)((float)msec * scale), 2);
        jw.object();
        jw.key("id");
        jw.value(String.valueOf(index));
        jw.key("offset");
        jw.value(msec);
        jw.key("width");
        jw.value(percent);
        jw.key("category");
        jw.value(info.category);
        jw.key("received");
        jw.value(info.received);
        jw.key("topic");
        jw.value(info.topic);
        if (info.info != null) {
            jw.key("info");
            jw.value(info.info);
        }
        jw.key("properties");
        jw.object();
        if (info.properties != null && info.properties.size() > 0) {
            for (Map.Entry current : info.properties.entrySet()) {
                jw.key(current.getKey().toString());
                jw.value(current.getValue());
            }
        }
        jw.endObject();
        jw.endObject();
    }

    public void updateConfiguration(Dictionary dict) {
        this.collector.updateConfiguration(dict);
    }

    public EventCollector getCollector() {
        return this.collector;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setConfigAdminAvailable(boolean flag) {
        this.configAdminAvailable = flag;
    }
}

