/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Map;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.server.Environment;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.ExternalTerminal;

public class SshTerminal
extends ExternalTerminal
implements Terminal {
    private Environment environment;

    public SshTerminal(Environment environment, InputStream input, OutputStream output) throws IOException {
        super("Karaf SSH terminal", (String)environment.getEnv().get("TERM"), input, output, "UTF-8");
        this.environment = environment;
        this.environment.addSignalListener(this::handleSignal);
        for (Map.Entry e : environment.getPtyModes().entrySet()) {
            switch ((PtyMode)e.getKey()) {
                case VINTR: {
                    this.attributes.setControlChar(Attributes.ControlChar.VINTR, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VQUIT: {
                    this.attributes.setControlChar(Attributes.ControlChar.VQUIT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VERASE: {
                    this.attributes.setControlChar(Attributes.ControlChar.VERASE, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VKILL: {
                    this.attributes.setControlChar(Attributes.ControlChar.VKILL, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOF: {
                    this.attributes.setControlChar(Attributes.ControlChar.VEOF, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOL: {
                    this.attributes.setControlChar(Attributes.ControlChar.VEOL, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VEOL2: {
                    this.attributes.setControlChar(Attributes.ControlChar.VEOL2, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTART: {
                    this.attributes.setControlChar(Attributes.ControlChar.VSTART, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTOP: {
                    this.attributes.setControlChar(Attributes.ControlChar.VSTOP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSUSP: {
                    this.attributes.setControlChar(Attributes.ControlChar.VSUSP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VDSUSP: {
                    this.attributes.setControlChar(Attributes.ControlChar.VDSUSP, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VREPRINT: {
                    this.attributes.setControlChar(Attributes.ControlChar.VREPRINT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VWERASE: {
                    this.attributes.setControlChar(Attributes.ControlChar.VWERASE, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VLNEXT: {
                    this.attributes.setControlChar(Attributes.ControlChar.VLNEXT, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VSTATUS: {
                    this.attributes.setControlChar(Attributes.ControlChar.VSTATUS, ((Integer)e.getValue()).intValue());
                    break;
                }
                case VDISCARD: {
                    this.attributes.setControlChar(Attributes.ControlChar.VDISCARD, ((Integer)e.getValue()).intValue());
                    break;
                }
                case ECHO: {
                    this.attributes.setLocalFlag(Attributes.LocalFlag.ECHO, (Integer)e.getValue() != 0);
                    break;
                }
                case ICANON: {
                    this.attributes.setLocalFlag(Attributes.LocalFlag.ICANON, (Integer)e.getValue() != 0);
                    break;
                }
                case ISIG: {
                    this.attributes.setLocalFlag(Attributes.LocalFlag.ISIG, (Integer)e.getValue() != 0);
                    break;
                }
                case ICRNL: {
                    this.attributes.setInputFlag(Attributes.InputFlag.ICRNL, (Integer)e.getValue() != 0);
                    break;
                }
                case INLCR: {
                    this.attributes.setInputFlag(Attributes.InputFlag.INLCR, (Integer)e.getValue() != 0);
                    break;
                }
                case IGNCR: {
                    this.attributes.setInputFlag(Attributes.InputFlag.IGNCR, (Integer)e.getValue() != 0);
                    break;
                }
                case OCRNL: {
                    this.attributes.setOutputFlag(Attributes.OutputFlag.OCRNL, (Integer)e.getValue() != 0);
                    break;
                }
                case ONLCR: {
                    this.attributes.setOutputFlag(Attributes.OutputFlag.ONLCR, (Integer)e.getValue() != 0);
                    break;
                }
                case ONLRET: {
                    this.attributes.setOutputFlag(Attributes.OutputFlag.ONLRET, (Integer)e.getValue() != 0);
                    break;
                }
                case OPOST: {
                    this.attributes.setOutputFlag(Attributes.OutputFlag.OPOST, (Integer)e.getValue() != 0);
                }
            }
        }
        int w = Integer.valueOf((String)this.environment.getEnv().get("COLUMNS"));
        int h = Integer.valueOf((String)this.environment.getEnv().get("LINES"));
        this.setSize(new Size(w, h));
    }

    protected void handleSignal(org.apache.sshd.server.Signal signal) {
        if (signal == org.apache.sshd.server.Signal.INT) {
            this.raise(Terminal.Signal.INT);
        } else if (signal == org.apache.sshd.server.Signal.QUIT) {
            this.raise(Terminal.Signal.QUIT);
        } else if (signal == org.apache.sshd.server.Signal.TSTP) {
            this.raise(Terminal.Signal.TSTP);
        } else if (signal == org.apache.sshd.server.Signal.CONT) {
            this.raise(Terminal.Signal.CONT);
        } else if (signal == org.apache.sshd.server.Signal.WINCH) {
            int w = Integer.valueOf((String)this.environment.getEnv().get("COLUMNS"));
            int h = Integer.valueOf((String)this.environment.getEnv().get("LINES"));
            this.setSize(new Size(w, h));
            this.raise(Terminal.Signal.WINCH);
        }
    }

    public int getWidth() {
        return this.size.getColumns();
    }

    public int getHeight() {
        return this.size.getRows();
    }

    public void addSignalListener(SignalListener listener) {
    }

    public void addSignalListener(SignalListener listener, Signal ... signal) {
    }

    public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
    }

    public void removeSignalListener(SignalListener listener) {
    }

    public boolean isAnsiSupported() {
        return true;
    }

    public boolean isEchoEnabled() {
        return this.echo();
    }

    public void setEchoEnabled(boolean enabled) {
        this.echo(enabled);
    }
}

