/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Properties;
import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.ReconnectStrategy;
import org.springframework.messaging.tcp.TcpConnectionHandler;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.AbstractPromiseToListenableFutureAdapter;
import org.springframework.messaging.tcp.reactor.PassThroughPromiseToListenableFutureAdapter;
import org.springframework.messaging.tcp.reactor.Reactor11TcpConnection;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.core.Environment;
import reactor.core.composable.Composable;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.Promises;
import reactor.core.configuration.ConfigurationReader;
import reactor.core.configuration.DispatcherConfiguration;
import reactor.core.configuration.ReactorConfiguration;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.NetChannel;
import reactor.net.Reconnect;
import reactor.net.netty.tcp.NettyTcpClient;
import reactor.net.tcp.TcpClient;
import reactor.net.tcp.spec.TcpClientSpec;
import reactor.tuple.Tuple;
import reactor.tuple.Tuple2;

public class Reactor11TcpClient<P>
implements TcpOperations<P> {
    public static final Class<NettyTcpClient> REACTOR_TCP_CLIENT_TYPE = NettyTcpClient.class;
    private final TcpClient<Message<P>, Message<P>> tcpClient;
    private final Environment environment;

    public Reactor11TcpClient(String host, int port, Codec<Buffer, Message<P>, Message<P>> codec) {
        this.environment = new Environment((ConfigurationReader)new SynchronousDispatcherConfigReader());
        this.tcpClient = (TcpClient)((TcpClientSpec)new TcpClientSpec(REACTOR_TCP_CLIENT_TYPE).env(this.environment)).codec(codec).connect(host, port).get();
    }

    public Reactor11TcpClient(TcpClient<Message<P>, Message<P>> tcpClient) {
        Assert.notNull(tcpClient, (String)"'tcpClient' must not be null");
        this.tcpClient = tcpClient;
        this.environment = null;
    }

    @Override
    public ListenableFuture<Void> connect(TcpConnectionHandler<P> connectionHandler) {
        Promise promise = this.tcpClient.open();
        this.composeConnectionHandling((Composable<NetChannel<Message<P>, Message<P>>>)promise, connectionHandler);
        return new AbstractPromiseToListenableFutureAdapter<NetChannel<Message<P>, Message<P>>, Void>(promise){

            @Override
            protected Void adapt(NetChannel<Message<P>, Message<P>> result) {
                return null;
            }
        };
    }

    @Override
    public ListenableFuture<Void> connect(TcpConnectionHandler<P> connectionHandler, final ReconnectStrategy reconnectStrategy) {
        Assert.notNull((Object)reconnectStrategy, (String)"ReconnectStrategy must not be null");
        Reconnect reconnect = new Reconnect(){

            public Tuple2<InetSocketAddress, Long> reconnect(InetSocketAddress address, int attempt) {
                return Tuple.of((Object)address, (Object)reconnectStrategy.getTimeToNextAttempt(attempt));
            }
        };
        Stream stream = this.tcpClient.open(reconnect);
        this.composeConnectionHandling((Composable<NetChannel<Message<P>, Message<P>>>)stream, connectionHandler);
        Promise promise = Promises.next((Composable)stream).map(new Function<NetChannel<Message<P>, Message<P>>, Void>(){

            public Void apply(NetChannel<Message<P>, Message<P>> ch) {
                return null;
            }
        });
        return new PassThroughPromiseToListenableFutureAdapter<Void>((Promise<Void>)promise);
    }

    private void composeConnectionHandling(Composable<NetChannel<Message<P>, Message<P>>> composable, final TcpConnectionHandler<P> connectionHandler) {
        composable.when(Throwable.class, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable ex) {
                connectionHandler.afterConnectFailure(ex);
            }
        }).consume(new Consumer<NetChannel<Message<P>, Message<P>>>(){

            public void accept(NetChannel<Message<P>, Message<P>> connection) {
                connection.when(Throwable.class, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable ex) {
                        connectionHandler.handleFailure(ex);
                    }
                }).consume(new Consumer<Message<P>>(){

                    public void accept(Message<P> message) {
                        connectionHandler.handleMessage(message);
                    }
                }).on().close(new Runnable(){

                    @Override
                    public void run() {
                        connectionHandler.afterConnectionClosed();
                    }
                });
                connectionHandler.afterConnected(new Reactor11TcpConnection(connection));
            }
        });
    }

    @Override
    public ListenableFuture<Boolean> shutdown() {
        try {
            Promise promise = this.tcpClient.close();
            AbstractPromiseToListenableFutureAdapter<Boolean, Boolean> abstractPromiseToListenableFutureAdapter = new AbstractPromiseToListenableFutureAdapter<Boolean, Boolean>(promise){

                @Override
                protected Boolean adapt(Boolean result) {
                    return result;
                }
            };
            return abstractPromiseToListenableFutureAdapter;
        }
        finally {
            this.environment.shutdown();
        }
    }

    private static class SynchronousDispatcherConfigReader
    implements ConfigurationReader {
        private SynchronousDispatcherConfigReader() {
        }

        public ReactorConfiguration read() {
            return new ReactorConfiguration(Arrays.asList(new DispatcherConfiguration[0]), "sync", new Properties());
        }
    }
}

