/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.UUID;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.config.core.ConfigRepository;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRepositoryImpl
implements ConfigRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRepositoryImpl.class);
    private static final String FILEINSTALL_FILE_NAME = "felix.fileinstall.filename";
    private ConfigurationAdmin configAdmin;
    private File storage;

    public ConfigRepositoryImpl(ConfigurationAdmin configAdmin) {
        this(configAdmin, null);
    }

    public ConfigRepositoryImpl(ConfigurationAdmin configAdmin, File storage) {
        this.configAdmin = configAdmin;
        this.storage = storage;
    }

    @Override
    public void update(String pid, Dictionary<String, Object> props) throws IOException {
        LOGGER.trace("Update configuration {}", (Object)pid);
        Configuration cfg = this.configAdmin.getConfiguration(pid, null);
        cfg.update(props);
        try {
            this.updateStorage(pid, props);
        }
        catch (Exception e) {
            LOGGER.warn("Can't update cfg file", (Throwable)e);
        }
    }

    @Override
    public void delete(String pid) throws Exception {
        LOGGER.trace("Delete configuration {}", (Object)pid);
        Configuration configuration = this.configAdmin.getConfiguration(pid, null);
        configuration.delete();
        try {
            this.deleteStorage(pid);
        }
        catch (Exception e) {
            LOGGER.warn("Can't delete cfg file", (Throwable)e);
        }
    }

    protected void deleteStorage(String pid) throws Exception {
        if (this.storage != null) {
            File cfgFile = new File(this.storage, pid + ".cfg");
            LOGGER.trace("Delete {}", (Object)cfgFile.getName());
            cfgFile.delete();
        }
    }

    private File getCfgFileFromProperties(Dictionary<String, Object> properties) throws URISyntaxException, MalformedURLException {
        File cfgFile = null;
        if (properties != null) {
            Object val = properties.get(FILEINSTALL_FILE_NAME);
            if (val instanceof URL) {
                cfgFile = new File(((URL)val).toURI());
            }
            if (val instanceof URI) {
                cfgFile = new File((URI)val);
            }
            if (val instanceof String) {
                cfgFile = new File(new URL((String)val).toURI());
            }
        }
        return cfgFile;
    }

    protected void updateStorage(String pid, Dictionary<String, Object> props) throws IOException {
        if (this.storage != null) {
            Dictionary oldProps;
            Configuration cfg = this.configAdmin.getConfiguration(pid, null);
            File cfgFile = new File(this.storage, pid + ".cfg");
            if (cfg != null && (oldProps = cfg.getProperties()) != null && oldProps.get(FILEINSTALL_FILE_NAME) != null) {
                try {
                    cfgFile = this.getCfgFileFromProperties(oldProps);
                    if (cfgFile == null) {
                        throw new IOException("The configuration value '" + oldProps.get(FILEINSTALL_FILE_NAME) + "' for ' + FILEINSTALL_FILE_NAME + ' does not represent a valid file location.");
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            LOGGER.trace("Update {}", (Object)cfgFile.getName());
            Properties properties = new Properties(cfgFile);
            Enumeration<String> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if ("service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key) || props.get(key) == null) continue;
                properties.put(key, props.get(key).toString());
            }
            ArrayList<String> propertiesToRemove = new ArrayList<String>();
            for (String key : properties.keySet()) {
                if (props.get(key) != null || "service.pid".equals(key) || "service.factoryPid".equals(key) || FILEINSTALL_FILE_NAME.equals(key)) continue;
                propertiesToRemove.add(key);
            }
            for (String key : propertiesToRemove) {
                properties.remove(key);
            }
            this.storage.mkdirs();
            properties.save();
        }
    }

    @Override
    public Dictionary<String, Object> getConfigProperties(String pid) throws IOException, InvalidSyntaxException {
        Configuration configuration;
        if (pid != null && this.configAdmin != null && (configuration = this.configAdmin.getConfiguration(pid, null)) != null) {
            Dictionary props = configuration.getProperties();
            return props != null ? props : new Hashtable();
        }
        return null;
    }

    @Override
    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, Dictionary<String, Object> properties) {
        return this.createFactoryConfiguration(factoryPid, null, properties);
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, String alias, Dictionary<String, Object> properties) {
        try {
            Configuration config = this.configAdmin.createFactoryConfiguration(factoryPid, null);
            if (this.storage != null && properties.get(FILEINSTALL_FILE_NAME) == null) {
                if (alias == null) {
                    alias = UUID.randomUUID().toString().replaceAll("-", "");
                }
                String cfgFileName = factoryPid + "-" + alias + ".cfg";
                File cfgFile = new File(this.storage, cfgFileName);
                properties.put(FILEINSTALL_FILE_NAME, cfgFile.getCanonicalFile().toURI().toString());
            }
            config.update(properties);
            String pid = config.getPid();
            this.updateStorage(pid, properties);
            return pid;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

