/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.extender;

import java.util.Objects;

public class Feature {
    private final String m_name;
    private final String m_version;

    public Feature(String name) {
        this(name, null);
    }

    public Feature(String name, String version) {
        this.m_name = Objects.requireNonNull(name);
        this.m_version = version;
    }

    public String getName() {
        return this.m_name;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String toString() {
        return String.format("Feature[name=%s, version=%s]", this.m_name, this.m_version);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return Objects.equals(this.m_name, other.m_name) && Objects.equals(this.m_version, other.m_version);
    }
}

