/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.forward.DefaultTcpipForwarder;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.forward.TcpipForwarderFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.EventListenerUtils;

public class DefaultTcpipForwarderFactory
implements TcpipForwarderFactory,
PortForwardingEventListenerManager {
    public static final DefaultTcpipForwarderFactory INSTANCE = new DefaultTcpipForwarderFactory(){

        @Override
        public void addPortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("addPortForwardingListener(" + listener + ") N/A on default instance");
        }

        @Override
        public void removePortForwardingEventListener(PortForwardingEventListener listener) {
            throw new UnsupportedOperationException("removePortForwardingEventListener(" + listener + ") N/A on default instance");
        }

        @Override
        public PortForwardingEventListener getPortForwardingEventListenerProxy() {
            return PortForwardingEventListener.EMPTY;
        }
    };
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final PortForwardingEventListener listenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.getClass().getClassLoader(), this.listeners);

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public TcpipForwarder create(ConnectionService service) {
        DefaultTcpipForwarder forwarder = new DefaultTcpipForwarder(service);
        forwarder.addPortForwardingEventListenerManager(this);
        return forwarder;
    }
}

